/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.part;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import com.mekeng.github.common.me.GasTickRates;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.part.PartSharedGasBus;
import javax.annotation.Nonnull;
import mekanism.api.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class PartGasExportBus
extends PartSharedGasBus {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("mekeng", "part/gas_export_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("mekeng", "part/gas_export_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("mekeng", "part/gas_export_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("mekeng", "part/gas_export_bus_has_channel")});
    private final IActionSource source;

    public PartGasExportBus(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.CRAFT_ONLY, (Enum)YesNo.NO);
        this.getConfigManager().registerSetting(Settings.SCHEDULING_MODE, (Enum)SchedulingMode.DEFAULT);
        this.source = new MachineSource((IActionHost)this);
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(GasTickRates.GasExportBus.getMin(), GasTickRates.GasExportBus.getMax(), this.isSleeping(), false);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        return this.canDoBusWork() ? this.doBusWork() : TickRateModulation.IDLE;
    }

    @Override
    protected boolean canDoBusWork() {
        return this.getProxy().isActive();
    }

    @Override
    public boolean isExport() {
        return true;
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        TileEntity te = this.getConnectedTE();
        if (te != null && te.hasCapability(Capabilities.GAS_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d())) {
            try {
                EnumFacing side = this.getSide().getFacing().func_176734_d();
                IGasHandler gh = (IGasHandler)te.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, side);
                IMEMonitor inv = this.getProxy().getStorage().getInventory((IStorageChannel)this.getChannel());
                if (gh != null) {
                    for (int i = 0; i < this.getConfig().size(); ++i) {
                        int wasInserted;
                        AEGasStack gas = AEGasStack.of(this.getConfig().getGasStack(i));
                        if (gas == null) continue;
                        IAEGasStack toExtract = (IAEGasStack)gas.copy();
                        toExtract.setStackSize(this.calculateAmountToSend());
                        IAEGasStack out = (IAEGasStack)inv.extractItems((IAEStack)toExtract, Actionable.SIMULATE, this.source);
                        if (out == null || (wasInserted = gh.receiveGas(side, out.getGasStack(), true)) <= 0) continue;
                        toExtract.setStackSize(wasInserted);
                        inv.extractItems((IAEStack)toExtract, Actionable.MODULATE, this.source);
                        return TickRateModulation.FASTER;
                    }
                    return TickRateModulation.SLOWER;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return TickRateModulation.SLEEP;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

