/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.part;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import com.mekeng.github.MekEng;
import com.mekeng.github.common.me.GasTickRates;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.part.PartSharedGasBus;
import com.mekeng.github.util.Utils;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class PartGasImportBus
extends PartSharedGasBus {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("mekeng", "part/gas_import_bus_base");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("mekeng", "part/gas_import_bus_off")});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("mekeng", "part/gas_import_bus_on")});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("mekeng", "part/gas_import_bus_has_channel")});
    private final IActionSource source;

    public PartGasImportBus(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.CRAFT_ONLY, (Enum)YesNo.NO);
        this.getConfigManager().registerSetting(Settings.SCHEDULING_MODE, (Enum)SchedulingMode.DEFAULT);
        this.source = new MachineSource((IActionHost)this);
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(GasTickRates.GasImportBus.getMin(), GasTickRates.GasImportBus.getMax(), this.isSleeping(), false);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        return this.canDoBusWork() ? this.doBusWork() : TickRateModulation.IDLE;
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        TileEntity te = this.getConnectedTE();
        if (te != null && te.hasCapability(Capabilities.GAS_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d())) {
            try {
                EnumFacing side = this.getSide().getFacing().func_176734_d();
                IGasHandler gh = (IGasHandler)te.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, side);
                IMEMonitor inv = this.getProxy().getStorage().getInventory((IStorageChannel)this.getChannel());
                if (gh != null) {
                    GasStack gasStack = gh.drawGas(side, this.calculateAmountToSend(), false);
                    if (this.filterEnabled() && !this.isInFilter(gasStack)) {
                        return TickRateModulation.SLOWER;
                    }
                    AEGasStack aeGasStack = AEGasStack.of(gasStack);
                    if (aeGasStack != null) {
                        IAEGasStack notInserted = (IAEGasStack)inv.injectItems((IAEStack)aeGasStack, Actionable.MODULATE, this.source);
                        if (notInserted != null && notInserted.getStackSize() > 0L) {
                            aeGasStack.decStackSize(notInserted.getStackSize());
                        }
                        Utils.drawGas(gh, aeGasStack.getGasStack(), side, aeGasStack.getGasStack().amount, true);
                        return TickRateModulation.FASTER;
                    }
                    return TickRateModulation.IDLE;
                }
            }
            catch (GridAccessException e) {
                MekEng.log.error((Object)e);
            }
        }
        return TickRateModulation.SLEEP;
    }

    @Override
    protected boolean canDoBusWork() {
        return this.getProxy().isActive();
    }

    @Override
    public boolean isExport() {
        return false;
    }

    private boolean isInFilter(GasStack gas) {
        if (gas == null) {
            return false;
        }
        for (int i = 0; i < this.getConfig().size(); ++i) {
            GasStack filter = this.getConfig().getGasStack(i);
            if (!gas.isGasEqual(filter)) continue;
            return true;
        }
        return false;
    }

    private boolean filterEnabled() {
        for (int i = 0; i < this.getConfig().size(); ++i) {
            if (this.getConfig().getGasStack(i) == null) continue;
            return true;
        }
        return false;
    }

    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

