/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.part;

import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.GuiWrapper;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.parts.PartBasicState;
import appeng.parts.PartModel;
import appeng.util.Platform;
import com.mekeng.github.common.ItemAndBlocks;
import com.mekeng.github.common.container.handler.AEGuiBridge;
import com.mekeng.github.common.container.handler.GuiHandler;
import com.mekeng.github.common.container.handler.MkEGuis;
import com.mekeng.github.common.me.duality.IGasInterfaceHost;
import com.mekeng.github.common.me.duality.impl.DualityGasInterface;
import com.mekeng.github.common.me.inventory.IConfigurableGasInventory;
import com.mekeng.github.common.me.inventory.IGasInventory;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;

public class PartGasInterface
extends PartBasicState
implements IGridTickable,
IStorageMonitorable,
IGasInterfaceHost,
IPriorityHost,
IConfigurableGasInventory {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("mekeng", "part/gas_interface_base");
    @PartModels
    public static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("mekeng", "part/gas_interface_off")});
    @PartModels
    public static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("mekeng", "part/gas_interface_on")});
    @PartModels
    public static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("mekeng", "part/gas_interface_has_channel")});
    private final DualityGasInterface duality = new DualityGasInterface(this.getProxy(), this);

    public PartGasInterface(ItemStack is) {
        super(is);
    }

    public void setPartHostInfo(AEPartLocation side, IPartHost host, TileEntity tile) {
        super.setPartHostInfo(side, host, tile);
        this.duality.getTankHandler().setSide(this.getTargets());
    }

    @Override
    public DualityGasInterface getDualityGasInterface() {
        return this.duality;
    }

    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        this.duality.notifyNeighbors();
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.duality.notifyNeighbors();
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    public void gridChanged() {
        this.duality.gridChanged();
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.duality.readFromNBT(data);
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.duality.writeToNBT(data);
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        this.duality.addDrops(drops);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 4.0f;
    }

    public boolean onPartActivate(EntityPlayer p, EnumHand hand, Vec3d pos) {
        if (Platform.isServer() && this.getActionableNode() != null) {
            GuiHandler.openPartGui(p, this.getTile().func_145831_w(), this.getTile().func_174877_v(), this.getSide().getFacing(), MkEGuis.GAS_INTERFACE);
        }
        return true;
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        return this.duality.getInventory(channel);
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return this.duality.getTickingRequest(node);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        return this.duality.tickingRequest(node, ticksSinceLastCall);
    }

    @Override
    public EnumSet<EnumFacing> getTargets() {
        return EnumSet.of(this.getSide().getFacing());
    }

    @Override
    public TileEntity getTileEntity() {
        return super.getHost().getTile();
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public int getPriority() {
        return this.duality.getPriority();
    }

    public void setPriority(int newValue) {
        this.duality.setPriority(newValue);
    }

    public boolean hasCapability(Capability<?> capabilityClass) {
        return this.duality.hasCapability(capabilityClass, this.getSide().getFacing());
    }

    public <T> T getCapability(Capability<T> capabilityClass) {
        return this.duality.getCapability(capabilityClass, this.getSide().getFacing());
    }

    public int getInstalledUpgrades(Upgrades u) {
        return this.duality.getInstalledUpgrades(u);
    }

    public IConfigManager getConfigManager() {
        return this.duality.getConfigManager();
    }

    public IItemHandler getInventoryByName(String name) {
        return this.duality.getInventoryByName(name);
    }

    @Override
    public IGasInventory getGasInventoryByName(String name) {
        return this.duality.getGasInventoryByName(name);
    }

    public ItemStack getItemStackRepresentation() {
        return new ItemStack(ItemAndBlocks.GAS_INTERFACE_PART);
    }

    public GuiBridge getGuiBridge() {
        return GuiWrapper.INSTANCE.wrap((GuiWrapper.IExternalGui)AEGuiBridge.GAS_INTERFACE);
    }
}

