/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.part;

import appeng.api.AEApi;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.cache.NetworkMonitor;
import appeng.parts.PartModel;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import com.mekeng.github.common.container.handler.GuiHandler;
import com.mekeng.github.common.container.handler.MkEGuis;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.inventory.IConfigurableGasInventory;
import com.mekeng.github.common.me.inventory.IGasInventory;
import com.mekeng.github.common.me.inventory.IGasInventoryHost;
import com.mekeng.github.common.me.inventory.impl.GasInventory;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.common.part.PartGasUpgradeable;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PartGasLevelEmitter
extends PartGasUpgradeable
implements IStackWatcherHost,
IConfigManagerHost,
IGasInventoryHost,
IMEMonitorHandlerReceiver<IAEGasStack>,
IConfigurableGasInventory {
    @PartModels
    public static final ResourceLocation MODEL_BASE_OFF = new ResourceLocation("appliedenergistics2", "part/level_emitter_base_off");
    @PartModels
    public static final ResourceLocation MODEL_BASE_ON = new ResourceLocation("appliedenergistics2", "part/level_emitter_base_on");
    @PartModels
    public static final ResourceLocation MODEL_STATUS_OFF = new ResourceLocation("appliedenergistics2", "part/level_emitter_status_off");
    @PartModels
    public static final ResourceLocation MODEL_STATUS_ON = new ResourceLocation("appliedenergistics2", "part/level_emitter_status_on");
    @PartModels
    public static final ResourceLocation MODEL_STATUS_HAS_CHANNEL = new ResourceLocation("appliedenergistics2", "part/level_emitter_status_has_channel");
    public static final PartModel MODEL_OFF_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE_OFF, MODEL_STATUS_OFF});
    public static final PartModel MODEL_OFF_ON = new PartModel(new ResourceLocation[]{MODEL_BASE_OFF, MODEL_STATUS_ON});
    public static final PartModel MODEL_OFF_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE_OFF, MODEL_STATUS_HAS_CHANNEL});
    public static final PartModel MODEL_ON_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE_ON, MODEL_STATUS_OFF});
    public static final PartModel MODEL_ON_ON = new PartModel(new ResourceLocation[]{MODEL_BASE_ON, MODEL_STATUS_ON});
    public static final PartModel MODEL_ON_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE_ON, MODEL_STATUS_HAS_CHANNEL});
    private static final int FLAG_ON = 4;
    private boolean prevState = false;
    private long lastReportedValue = 0L;
    private long reportingValue = 0L;
    private IStackWatcher stackWatcher = null;
    private final GasInventory config = new GasInventory(1, this);

    public PartGasLevelEmitter(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_EMITTER, (Enum)RedstoneMode.HIGH_SIGNAL);
    }

    public long getReportingValue() {
        return this.reportingValue;
    }

    public void setReportingValue(long v) {
        this.reportingValue = v;
        this.updateState();
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.configureWatchers();
    }

    public void updateWatcher(IStackWatcher newWatcher) {
        this.stackWatcher = newWatcher;
        this.configureWatchers();
    }

    public void onStackChange(IItemList<?> o, IAEStack<?> fullStack, IAEStack<?> diffStack, IActionSource src, IStorageChannel<?> chan) {
        if (chan == AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class) && fullStack.equals((Object)this.config.getGasStack(0))) {
            this.lastReportedValue = fullStack.getStackSize();
            this.updateState();
        }
    }

    @Override
    public void onGasInventoryChanged(IGasInventory inv, int slot) {
        this.configureWatchers();
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange powerEvent) {
        if (this.getProxy().isActive()) {
            this.onListUpdate();
        }
        this.updateState();
    }

    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        if (this.getProxy().isActive()) {
            this.onListUpdate();
        }
        this.updateState();
    }

    public int isProvidingStrongPower() {
        return this.prevState ? 15 : 0;
    }

    public int isProvidingWeakPower() {
        return this.prevState ? 15 : 0;
    }

    protected int populateFlags(int cf) {
        return cf | (this.prevState ? 4 : 0);
    }

    public boolean isValid(Object effectiveGrid) {
        try {
            return this.getProxy().getGrid() == effectiveGrid;
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    public void postChange(IBaseMonitor<IAEGasStack> monitor, Iterable<IAEGasStack> change, IActionSource actionSource) {
        this.updateReportingValue((IMEMonitor<IAEGasStack>)((IMEMonitor)monitor));
    }

    public void onListUpdate() {
        try {
            IStorageChannel channel = AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class);
            IMEMonitor inventory = this.getProxy().getStorage().getInventory(channel);
            this.updateReportingValue((IMEMonitor<IAEGasStack>)inventory);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void updateState() {
        boolean isOn = this.isLevelEmitterOn();
        if (this.prevState != isOn) {
            this.getHost().markForUpdate();
            TileEntity te = this.getHost().getTile();
            this.prevState = isOn;
            Platform.notifyBlocksOfNeighbors((World)te.func_145831_w(), (BlockPos)te.func_174877_v());
            Platform.notifyBlocksOfNeighbors((World)te.func_145831_w(), (BlockPos)te.func_174877_v().func_177972_a(this.getSide().getFacing()));
        }
    }

    private void configureWatchers() {
        IGasStorageChannel channel = (IGasStorageChannel)AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class);
        if (this.stackWatcher != null) {
            this.stackWatcher.reset();
            AEGasStack myStack = AEGasStack.of(this.config.getGasStack(0));
            try {
                if (myStack != null) {
                    this.getProxy().getStorage().getInventory((IStorageChannel)channel).removeListener((IMEMonitorHandlerReceiver)this);
                    this.stackWatcher.add((IAEStack)myStack);
                } else {
                    this.getProxy().getStorage().getInventory((IStorageChannel)channel).addListener((IMEMonitorHandlerReceiver)this, (Object)this.getProxy().getGrid());
                }
                IMEMonitor inventory = this.getProxy().getStorage().getInventory((IStorageChannel)channel);
                this.updateReportingValue((IMEMonitor<IAEGasStack>)inventory);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    private void updateReportingValue(IMEMonitor<IAEGasStack> monitor) {
        AEGasStack myStack = AEGasStack.of(this.config.getGasStack(0));
        if (myStack == null) {
            if (monitor instanceof NetworkMonitor) {
                this.lastReportedValue = ((NetworkMonitor)monitor).getGridCurrentCount();
            }
        } else {
            IAEGasStack r = (IAEGasStack)monitor.getStorageList().findPrecise((IAEStack)myStack);
            this.lastReportedValue = r == null ? 0L : r.getStackSize();
        }
        this.updateState();
    }

    private boolean isLevelEmitterOn() {
        if (Platform.isClient()) {
            return (this.getClientFlags() & 4) == 4;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        boolean flipState = this.getConfigManager().getSetting(Settings.REDSTONE_EMITTER) == RedstoneMode.LOW_SIGNAL;
        return flipState == this.reportingValue > this.lastReportedValue;
    }

    @Nonnull
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    public float getCableConnectionLength(AECableType cable) {
        return 16.0f;
    }

    public boolean canConnectRedstone() {
        return true;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 16.0);
    }

    public void randomDisplayTick(World world, BlockPos pos, Random r) {
        if (this.isLevelEmitterOn()) {
            AEPartLocation d = this.getSide();
            double d0 = (double)((float)d.xOffset * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)d.yOffset * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)d.zOffset * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            world.func_175688_a(EnumParticleTypes.REDSTONE, 0.5 + (double)pos.func_177958_n() + d0, 0.5 + (double)pos.func_177956_o() + d1, 0.5 + (double)pos.func_177952_p() + d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isServer()) {
            GuiHandler.openPartGui(player, this.getTile().func_145831_w(), this.getTile().func_174877_v(), this.getSide().getFacing(), MkEGuis.GAS_LEVEL_EMITTER);
        }
        return true;
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return this.isLevelEmitterOn() ? MODEL_ON_HAS_CHANNEL : MODEL_OFF_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return this.isLevelEmitterOn() ? MODEL_ON_ON : MODEL_OFF_ON;
        }
        return this.isLevelEmitterOn() ? MODEL_ON_OFF : MODEL_OFF_OFF;
    }

    public IGasInventory getConfig() {
        return this.config;
    }

    @Override
    public IGasInventory getGasInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        return null;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.lastReportedValue = data.func_74763_f("lastReportedValue");
        this.reportingValue = data.func_74763_f("reportingValue");
        this.prevState = data.func_74767_n("prevState");
        this.config.load(data.func_74775_l("config"));
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74772_a("lastReportedValue", this.lastReportedValue);
        data.func_74772_a("reportingValue", this.reportingValue);
        data.func_74757_a("prevState", this.prevState);
        data.func_74782_a("config", (NBTBase)this.config.save());
    }
}

