/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.part;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.GuiWrapper;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.cache.GridStorageCache;
import appeng.me.helpers.IGridProxyable;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.ITickingMonitor;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.PartModel;
import appeng.tile.networking.TileCableBus;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.IPartitionList;
import appeng.util.prioritylist.PrecisePriorityList;
import com.mekeng.github.common.ItemAndBlocks;
import com.mekeng.github.common.container.handler.AEGuiBridge;
import com.mekeng.github.common.container.handler.GuiHandler;
import com.mekeng.github.common.container.handler.MkEGuis;
import com.mekeng.github.common.me.GasTickRates;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.duality.IGasInterfaceHost;
import com.mekeng.github.common.me.inventory.IConfigurableGasInventory;
import com.mekeng.github.common.me.inventory.IGasInventory;
import com.mekeng.github.common.me.inventory.IGasInventoryHost;
import com.mekeng.github.common.me.inventory.impl.GasHandlerAdapter;
import com.mekeng.github.common.me.inventory.impl.GasInventory;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.common.part.PartGasUpgradeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public class PartGasStorageBus
extends PartGasUpgradeable
implements IGridTickable,
ICellContainer,
IMEMonitorHandlerReceiver<IAEGasStack>,
IGasInventoryHost,
IConfigurableGasInventory,
IPriorityHost {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("mekeng", "part/gas_storage_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("mekeng", "part/gas_storage_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("mekeng", "part/gas_storage_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("mekeng", "part/gas_storage_bus_has_channel")});
    private final IActionSource source;
    private final GasInventory config = new GasInventory(63, this);
    private int priority = 0;
    private boolean cached = false;
    private ITickingMonitor monitor = null;
    private MEInventoryHandler<IAEGasStack> handler = null;
    private int handlerHash = 0;
    private boolean wasActive = false;
    private byte resetCacheLogic = 0;
    private boolean accessChanged;
    private boolean readOncePass;

    public PartGasStorageBus(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.ACCESS, (Enum)AccessRestriction.READ_WRITE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.STORAGE_FILTER, (Enum)StorageFilter.EXTRACTABLE_ONLY);
        this.source = new MachineSource((IActionHost)this);
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.updateStatus();
    }

    protected void updateStatus() {
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                this.getHost().markForUpdate();
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged changedChannels) {
        this.updateStatus();
    }

    protected int getUpgradeSlots() {
        return 5;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (settingName.name().equals("ACCESS")) {
            this.accessChanged = true;
        }
        this.resetCache(true);
        this.getHost().markForSave();
    }

    @Override
    public void onGasInventoryChanged(IGasInventory inv, int slot) {
        if (inv == this.config) {
            this.resetCache(true);
        }
    }

    public void upgradesChanged() {
        super.upgradesChanged();
        this.resetCache(true);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.config.load(data.func_74775_l("config"));
        this.priority = data.func_74762_e("priority");
        this.accessChanged = false;
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("config", (NBTBase)this.config.save());
        data.func_74768_a("priority", this.priority);
    }

    @Override
    public IGasInventory getGasInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        return null;
    }

    protected void resetCache(boolean fullReset) {
        if (this.getHost() == null || this.getHost().getTile() == null || this.getHost().getTile().func_145831_w() == null || this.getHost().getTile().func_145831_w().field_72995_K) {
            return;
        }
        if (fullReset) {
            this.resetCacheLogic = (byte)2;
        } else if (this.resetCacheLogic < 2) {
            this.resetCacheLogic = 1;
        }
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public boolean isValid(Object verificationToken) {
        return this.handler == verificationToken;
    }

    public void postChange(IBaseMonitor<IAEGasStack> monitor, Iterable<IAEGasStack> change, IActionSource source) {
        if (this.getProxy().isActive()) {
            Iterable<IAEGasStack> filteredChanges = this.filterChanges(change);
            AccessRestriction currentAccess = (AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS);
            if (this.readOncePass) {
                this.readOncePass = false;
                try {
                    this.getProxy().getStorage().postAlterationOfStoredItems(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class), filteredChanges, this.source);
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
                return;
            }
            if (!currentAccess.hasPermission(AccessRestriction.READ)) {
                return;
            }
            try {
                this.getProxy().getStorage().postAlterationOfStoredItems(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class), filteredChanges, source);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    public void onListUpdate() {
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 15.0, 13.0, 13.0, 16.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 15.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    public void onNeighborChanged(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        if (pos.func_177972_a(this.getSide().getFacing()).equals((Object)neighbor)) {
            TileEntity te = w.func_175625_s(neighbor);
            if (te instanceof TileCableBus) {
                IPart iPart = ((TileCableBus)te).getPart(this.getSide().getOpposite());
                if (iPart == null || iPart instanceof IGasInterfaceHost) {
                    this.resetCache(true);
                    this.resetCache();
                }
            } else if (te == null || te instanceof IGasInterfaceHost) {
                this.resetCache(true);
                this.resetCache();
            } else {
                this.resetCache(false);
            }
        }
    }

    public float getCableConnectionLength(AECableType cable) {
        return 4.0f;
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isServer() && this.getActionableNode() != null) {
            GuiHandler.openPartGui(player, this.getTile().func_145831_w(), this.getTile().func_174877_v(), this.getSide().getFacing(), MkEGuis.GAS_STORAGE_BUS);
        }
        return true;
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(GasTickRates.GasStorageBus.getMin(), GasTickRates.GasStorageBus.getMax(), this.monitor == null, true);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        if (this.resetCacheLogic != 0) {
            this.resetCache();
        }
        if (this.monitor != null) {
            return this.monitor.onTick();
        }
        return TickRateModulation.SLEEP;
    }

    protected void resetCache() {
        boolean fullReset = this.resetCacheLogic == 2;
        this.resetCacheLogic = 0;
        MEInventoryHandler<IAEGasStack> in = this.getInternalHandler();
        IItemList before = ((IGasStorageChannel)AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)).createList();
        if (in != null) {
            if (this.accessChanged) {
                AccessRestriction currentAccess = (AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS);
                AccessRestriction oldAccess = (AccessRestriction)((ConfigManager)this.getConfigManager()).getOldSetting(Settings.ACCESS);
                if (oldAccess.hasPermission(AccessRestriction.READ) && !currentAccess.hasPermission(AccessRestriction.READ)) {
                    this.readOncePass = true;
                }
                in.setBaseAccess(oldAccess);
                before = in.getAvailableItems(before);
                in.setBaseAccess(currentAccess);
                this.accessChanged = false;
            } else {
                before = in.getAvailableItems(before);
            }
        }
        this.cached = false;
        if (fullReset) {
            this.handlerHash = 0;
        }
        MEInventoryHandler<IAEGasStack> out = this.getInternalHandler();
        IItemList after = ((IGasStorageChannel)AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)).createList();
        if (in != out) {
            if (out != null) {
                after = out.getAvailableItems(after);
            }
            Platform.postListChanges((IItemList)before, (IItemList)after, (IMEMonitorHandlerReceiver)this, (IActionSource)this.source);
        }
    }

    private IMEInventory<IAEGasStack> getInventoryWrapper(TileEntity target) {
        EnumFacing targetSide = this.getSide().getFacing().func_176734_d();
        IStorageMonitorableAccessor accessor = (IStorageMonitorableAccessor)target.getCapability(appeng.capabilities.Capabilities.STORAGE_MONITORABLE_ACCESSOR, targetSide);
        if (accessor != null) {
            IStorageMonitorable inventory = accessor.getInventory(this.source);
            if (inventory != null) {
                return inventory.getInventory(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class));
            }
            return null;
        }
        IGasHandler handlerExt = (IGasHandler)target.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, targetSide);
        if (handlerExt != null) {
            return new GasHandlerAdapter(handlerExt, (IGridProxyable)this, targetSide);
        }
        return null;
    }

    private int createHandlerHash(TileEntity target) {
        if (target == null) {
            return 0;
        }
        EnumFacing targetSide = this.getSide().getFacing().func_176734_d();
        if (target.hasCapability(appeng.capabilities.Capabilities.STORAGE_MONITORABLE_ACCESSOR, targetSide)) {
            return Objects.hash(target, target.getCapability(appeng.capabilities.Capabilities.STORAGE_MONITORABLE_ACCESSOR, targetSide));
        }
        IGasHandler gasHandler = (IGasHandler)target.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, targetSide);
        if (gasHandler != null) {
            return Objects.hash(target, gasHandler, gasHandler.getTankInfo().length);
        }
        return 0;
    }

    public MEInventoryHandler<IAEGasStack> getInternalHandler() {
        if (this.cached) {
            return this.handler;
        }
        boolean wasSleeping = this.monitor == null;
        this.cached = true;
        TileEntity self = this.getHost().getTile();
        TileEntity target = self.func_145831_w().func_175625_s(self.func_174877_v().func_177972_a(this.getSide().getFacing()));
        int newHandlerHash = this.createHandlerHash(target);
        if (newHandlerHash != 0 && newHandlerHash == this.handlerHash) {
            return this.handler;
        }
        this.handlerHash = newHandlerHash;
        this.handler = null;
        if (this.monitor != null) {
            ((IBaseMonitor)this.monitor).removeListener((IMEMonitorHandlerReceiver)this);
        }
        this.monitor = null;
        if (target != null) {
            IMEInventory<IAEGasStack> inv = this.getInventoryWrapper(target);
            if (inv instanceof ITickingMonitor) {
                this.monitor = (ITickingMonitor)inv;
                this.monitor.setActionSource(this.source);
                this.monitor.setMode((StorageFilter)this.getConfigManager().getSetting(Settings.STORAGE_FILTER));
            }
            if (inv != null) {
                this.handler = new MEInventoryHandler(inv, AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class));
                this.handler.setBaseAccess((AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS));
                this.handler.setWhitelist(this.getInstalledUpgrades(Upgrades.INVERTER) > 0 ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
                this.handler.setPriority(this.getPriority());
                this.handler.setStorageFilter((StorageFilter)this.getConfigManager().getSetting(Settings.STORAGE_FILTER));
                IItemList priorityList = ((IGasStorageChannel)AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)).createList();
                int slotsToUse = 18 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 9;
                for (int x = 0; x < this.config.size() && x < slotsToUse; ++x) {
                    AEGasStack is = AEGasStack.of(this.config.getGasStack(x));
                    if (is == null) continue;
                    priorityList.add((IAEStack)is);
                }
                if (this.getInstalledUpgrades(Upgrades.STICKY) > 0) {
                    this.handler.setSticky(true);
                }
                if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
                    this.handler.setPartitionList((IPartitionList)new FuzzyPriorityList(priorityList, (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE)));
                } else {
                    this.handler.setPartitionList((IPartitionList)new PrecisePriorityList(priorityList));
                }
                if (inv instanceof IBaseMonitor && ((AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS)).hasPermission(AccessRestriction.READ)) {
                    ((IBaseMonitor)inv).addListener((IMEMonitorHandlerReceiver)this, this.handler);
                }
            }
        }
        if (wasSleeping != (this.monitor == null)) {
            try {
                ITickManager tm = this.getProxy().getTick();
                if (this.monitor == null) {
                    tm.sleepDevice(this.getProxy().getNode());
                } else {
                    tm.wakeDevice(this.getProxy().getNode());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        try {
            ((GridStorageCache)this.getProxy().getGrid().getCache(IStorageGrid.class)).cellUpdate(null);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return this.handler;
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        MEInventoryHandler<IAEGasStack> out;
        if (channel == AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class) && (out = this.getInternalHandler()) != null) {
            return Collections.singletonList(out);
        }
        return Collections.emptyList();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.resetCache(true);
    }

    public void blinkCell(int slot) {
    }

    public void saveChanges(@Nullable ICellInventory<?> cellInventory) {
    }

    public IGasInventory getConfig() {
        return this.config;
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public ItemStack getItemStackRepresentation() {
        return new ItemStack(ItemAndBlocks.GAS_STORAGE_BUS);
    }

    public GuiBridge getGuiBridge() {
        return GuiWrapper.INSTANCE.wrap((GuiWrapper.IExternalGui)AEGuiBridge.GAS_STORAGE_BUS);
    }

    protected Iterable<IAEGasStack> filterChanges(Iterable<IAEGasStack> change) {
        Enum storageFilter = this.getConfigManager().getSetting(Settings.STORAGE_FILTER);
        if (storageFilter == StorageFilter.EXTRACTABLE_ONLY && this.handler != null) {
            ArrayList<IAEGasStack> filteredList = new ArrayList<IAEGasStack>();
            for (IAEGasStack stack : change) {
                if (!this.handler.passesBlackOrWhitelist((IAEStack)stack)) continue;
                filteredList.add(stack);
            }
            return filteredList;
        }
        return change;
    }
}

