/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.part;

import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.IConfigManager;
import appeng.me.GridAccessException;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractPartDisplay;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import com.mekeng.github.common.container.handler.GuiHandler;
import com.mekeng.github.common.container.handler.MkEGuis;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.items.IItemHandler;

public class PartGasTerminal
extends AbstractPartDisplay
implements ITerminalHost,
IConfigManagerHost,
IViewCellStorage,
IAEAppEngInventory {
    private final IConfigManager cm = new ConfigManager((IConfigManagerHost)this);
    private final AppEngInternalInventory viewCell = new AppEngInternalInventory((IAEAppEngInventory)this, 5);
    public static final ResourceLocation MODEL_OFF = new ResourceLocation("mekeng", "part/gas_terminal_off");
    public static final ResourceLocation MODEL_ON = new ResourceLocation("mekeng", "part/gas_terminal_on");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL});

    public PartGasTerminal(ItemStack is) {
        super(is);
        this.cm.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.cm.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.cm.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (ItemStack is : this.viewCell) {
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    public IConfigManager getConfigManager() {
        return this.cm;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.cm.readFromNBT(data);
        this.viewCell.readFromNBT(data, "viewCell");
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.cm.writeToNBT(data);
        this.viewCell.writeToNBT(data, "viewCell");
    }

    @Nonnull
    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL);
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (!super.onPartActivate(player, hand, pos) && Platform.isServer() && this.getActionableNode() != null) {
            GuiHandler.openPartGui(player, this.getTile().func_145831_w(), this.getTile().func_174877_v(), this.getSide().getFacing(), MkEGuis.GAS_TERMINAL);
        }
        return true;
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        try {
            return this.getProxy().getStorage().getInventory(channel);
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public IItemHandler getViewCellStorage() {
        return this.viewCell;
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.getHost().markForSave();
    }
}

