/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.part;

import appeng.api.AEApi;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Upgrades;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.util.AECableType;
import appeng.me.GridAccessException;
import appeng.util.Platform;
import com.mekeng.github.common.container.handler.GuiHandler;
import com.mekeng.github.common.container.handler.MkEGuis;
import com.mekeng.github.common.me.inventory.IConfigurableGasInventory;
import com.mekeng.github.common.me.inventory.IGasInventory;
import com.mekeng.github.common.me.inventory.impl.GasInventory;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.common.part.IPartGroup;
import com.mekeng.github.common.part.PartGasUpgradeable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class PartSharedGasBus
extends PartGasUpgradeable
implements IGridTickable,
IConfigurableGasInventory,
IPartGroup {
    private final GasInventory config = new GasInventory(9);
    private boolean lastRedstone;

    public PartSharedGasBus(ItemStack is) {
        super(is);
    }

    public void upgradesChanged() {
        this.updateState();
    }

    public void onNeighborChanged(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        this.updateState();
        if (this.lastRedstone != this.getHost().hasRedstone(this.getSide())) {
            boolean bl = this.lastRedstone = !this.lastRedstone;
            if (this.lastRedstone && this.getRSMode() == RedstoneMode.SIGNAL_PULSE) {
                this.doBusWork();
            }
        }
    }

    private void updateState() {
        try {
            if (!this.isSleeping()) {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            } else {
                this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isServer()) {
            GuiHandler.openPartGui(player, this.getTile().func_145831_w(), this.getTile().func_174877_v(), this.getSide().getFacing(), MkEGuis.GAS_IO_BUS);
        }
        return true;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    protected TileEntity getConnectedTE() {
        TileEntity self = this.getHost().getTile();
        return this.getTileEntity(self, self.func_174877_v().func_177972_a(this.getSide().getFacing()));
    }

    private TileEntity getTileEntity(TileEntity self, BlockPos pos) {
        World w = self.func_145831_w();
        if (w.func_72863_F().func_186026_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) != null) {
            return w.func_175625_s(pos);
        }
        return null;
    }

    protected int calculateAmountToSend() {
        double amount = this.getChannel().transferFactor();
        switch (this.getInstalledUpgrades(Upgrades.SPEED)) {
            case 4: {
                amount *= 1.5;
            }
            case 3: {
                amount *= 2.0;
            }
            case 2: {
                amount *= 4.0;
            }
            case 1: {
                amount *= 8.0;
            }
        }
        return MathHelper.func_76128_c((double)amount);
    }

    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.config.load(extra.func_74775_l("io_config"));
    }

    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        extra.func_74782_a("io_config", (NBTBase)this.config.save());
    }

    public IGasInventory getConfig() {
        return this.config;
    }

    @Override
    public IGasInventory getGasInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        return null;
    }

    protected IGasStorageChannel getChannel() {
        return (IGasStorageChannel)AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    @Override
    public String getUnlocalizedGroupName() {
        return "group.mekeng.gas_io_bus";
    }

    protected abstract TickRateModulation doBusWork();

    protected abstract boolean canDoBusWork();

    public abstract boolean isExport();
}

