/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.part.p2p;

import appeng.api.parts.IPartModel;
import appeng.me.GridAccessException;
import appeng.parts.p2p.PartP2PTunnel;
import com.google.common.collect.Maps;
import com.mekeng.github.MekEng;
import com.mekeng.github.util.Ae2Reflect;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;

public class PartP2PGases
extends PartP2PTunnel<PartP2PGases>
implements IGasHandler {
    private static final Object MODELS = Ae2Reflect.createP2PModel("part/p2p/p2p_tunnel_gases");
    private static final ThreadLocal<Deque<PartP2PGases>> DEPTH = new ThreadLocal();
    private static final GasTankInfo[] ACTIVE_TANK = new GasTankInfo[]{new GasTank(100000)};
    private static final GasTankInfo[] INACTIVE_TANK = new GasTankInfo[]{new GasTank(0)};
    private Map.Entry<IGasHandler, EnumFacing> cachedGasTank;
    private int tmpUsed;

    public PartP2PGases(ItemStack is) {
        super(is);
    }

    public static Collection<ResourceLocation> getModels() {
        HashSet<ResourceLocation> all = new HashSet<ResourceLocation>();
        Ae2Reflect.getP2PModel(MODELS).forEach(m -> all.addAll(m.getModels()));
        return all;
    }

    public void onTunnelNetworkChange() {
        this.cachedGasTank = null;
    }

    public void onNeighborChanged(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        this.cachedGasTank = null;
        if (this.isOutput()) {
            try {
                for (PartP2PGases in : this.getInputs()) {
                    if (in == null) continue;
                    in.onTunnelNetworkChange();
                }
            }
            catch (GridAccessException e) {
                MekEng.log.error((Object)e);
            }
        }
    }

    public boolean hasCapability(Capability<?> capabilityClass) {
        if (capabilityClass == Capabilities.GAS_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capabilityClass);
    }

    public <T> T getCapability(Capability<T> capabilityClass) {
        if (capabilityClass == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capabilityClass);
    }

    @Nonnull
    public IPartModel getStaticModels() {
        return Ae2Reflect.getP2PModel(MODELS, this.isPowered(), this.isActive());
    }

    @Nonnull
    public GasTankInfo[] getTankInfo() {
        if (!this.isOutput()) {
            try {
                for (PartP2PGases tun : this.getInputs()) {
                    if (tun == null) continue;
                    return ACTIVE_TANK;
                }
            }
            catch (GridAccessException e) {
                MekEng.log.error((Object)e);
            }
        }
        return INACTIVE_TANK;
    }

    public int receiveGas(EnumFacing side, GasStack resource, boolean doTransfer) {
        if (side != null && side != this.getSide().getFacing()) {
            return 0;
        }
        Deque<PartP2PGases> stack = this.getDepth();
        for (PartP2PGases t : stack) {
            if (t != this) continue;
            return 0;
        }
        stack.push(this);
        List<PartP2PGases> list = this.getGasOutputs();
        int requestTotal = 0;
        Iterator<PartP2PGases> i = list.iterator();
        while (i.hasNext()) {
            PartP2PGases l = i.next();
            Map.Entry<IGasHandler, EnumFacing> gasTank = l.getTarget();
            l.tmpUsed = gasTank != null ? gasTank.getKey().receiveGas(gasTank.getValue(), resource.copy(), false) : 0;
            if (l.tmpUsed <= 0) {
                i.remove();
                continue;
            }
            requestTotal += l.tmpUsed;
        }
        if (requestTotal <= 0) {
            if (stack.pop() != this) {
                throw new IllegalStateException("Invalid Recursion detected.");
            }
            return 0;
        }
        if (!doTransfer) {
            if (stack.pop() != this) {
                throw new IllegalStateException("Invalid Recursion detected.");
            }
            return Math.min(resource.amount, requestTotal);
        }
        int available = resource.amount;
        i = list.iterator();
        int used = 0;
        while (i.hasNext() && available > 0) {
            Map.Entry<IGasHandler, EnumFacing> gasTank;
            PartP2PGases l = i.next();
            GasStack insert = resource.copy();
            insert.amount = (int)Math.ceil((double)insert.amount * ((double)l.tmpUsed / (double)requestTotal));
            if (insert.amount > available) {
                insert.amount = available;
            }
            l.tmpUsed = (gasTank = l.getTarget()) != null ? gasTank.getKey().receiveGas(gasTank.getValue(), insert.copy(), true) : 0;
            available -= insert.amount;
            used += l.tmpUsed;
        }
        if (stack.pop() != this) {
            throw new IllegalStateException("Invalid Recursion detected.");
        }
        return used;
    }

    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return true;
    }

    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    private Deque<PartP2PGases> getDepth() {
        Deque<PartP2PGases> s = DEPTH.get();
        if (s == null) {
            s = new ArrayDeque<PartP2PGases>();
            DEPTH.set(s);
        }
        return s;
    }

    private List<PartP2PGases> getGasOutputs() {
        ArrayList<PartP2PGases> outs = new ArrayList<PartP2PGases>();
        try {
            for (PartP2PGases l : this.getOutputs()) {
                Map.Entry<IGasHandler, EnumFacing> handler = l.getTarget();
                if (handler == null) continue;
                outs.add(l);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return outs;
    }

    private Map.Entry<IGasHandler, EnumFacing> getTarget() {
        if (!this.getProxy().isActive()) {
            return null;
        }
        if (this.cachedGasTank != null) {
            return this.cachedGasTank;
        }
        TileEntity te = this.getTile().func_145831_w().func_175625_s(this.getTile().func_174877_v().func_177972_a(this.getSide().getFacing()));
        if (te != null && te.hasCapability(Capabilities.GAS_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d())) {
            this.cachedGasTank = Maps.immutableEntry((Object)te.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d()), (Object)this.getSide().getFacing().func_176734_d());
            return this.cachedGasTank;
        }
        return null;
    }
}

