/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.part.reporting;

import appeng.api.AEApi;
import appeng.api.implementations.parts.IPartStorageMonitor;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.DimensionalCoord;
import appeng.client.render.TesrRenderHelper;
import appeng.core.localization.PlayerMessages;
import appeng.me.GridAccessException;
import appeng.parts.reporting.AbstractPartDisplay;
import appeng.util.Platform;
import com.mekeng.github.client.render.GasRenderHelper;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.util.Utils;
import com.mekeng.github.util.helpers.ItemGasHandler;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import mekanism.api.gas.GasStack;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractPartGasMonitor
extends AbstractPartDisplay
implements IPartStorageMonitor,
IStackWatcherHost {
    private IAEGasStack configuredGas;
    private long configuredAmount;
    private boolean isLocked;
    private IStackWatcher myWatcher;

    public AbstractPartGasMonitor(ItemStack is) {
        super(is);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isLocked = data.func_74767_n("isLocked");
        if (data.func_74764_b("configuredGas")) {
            NBTTagCompound myGas = data.func_74775_l("configuredGas");
            this.configuredGas = AEGasStack.of(myGas);
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("isLocked", this.isLocked);
        if (this.configuredGas != null) {
            NBTTagCompound myGas = new NBTTagCompound();
            this.configuredGas.writeToNBT(myGas);
            data.func_74782_a("configuredGas", (NBTBase)myGas);
        }
    }

    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isLocked);
        data.writeBoolean(this.configuredGas != null);
        if (this.configuredGas != null) {
            this.configuredGas.writeToPacket(data);
        }
    }

    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        boolean isLocked = data.readBoolean();
        boolean needRedraw = this.isLocked != isLocked;
        this.isLocked = isLocked;
        this.configuredGas = data.readBoolean() ? AEGasStack.of(data) : null;
        return needRedraw;
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions((DimensionalCoord)this.getLocation(), (EntityPlayer)player)) {
            return false;
        }
        if (!this.isLocked) {
            GasStack gasInTank = null;
            ItemStack eq = player.func_184586_b(hand);
            ItemGasHandler itemGasHandler = Utils.getItemGasHandler(eq);
            if (itemGasHandler != null) {
                gasInTank = itemGasHandler.gasStack();
            }
            this.configuredGas = AEGasStack.of(gasInTank);
            if (this.configuredGas != null) {
                this.configuredGas.setStackSize(0L);
            }
        } else {
            return super.onPartActivate(player, hand, pos);
        }
        this.configureWatchers();
        this.getHost().markForSave();
        this.getHost().markForUpdate();
        return true;
    }

    public boolean onPartShiftActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions((DimensionalCoord)this.getLocation(), (EntityPlayer)player)) {
            return false;
        }
        if (player.func_184586_b(hand).func_190926_b()) {
            this.isLocked = !this.isLocked;
            player.func_145747_a((this.isLocked ? PlayerMessages.isNowLocked : PlayerMessages.isNowUnlocked).get());
            this.getHost().markForSave();
            this.getHost().markForUpdate();
        }
        return true;
    }

    private void configureWatchers() {
        if (this.myWatcher != null) {
            this.myWatcher.reset();
        }
        try {
            if (this.configuredGas != null) {
                if (this.myWatcher != null) {
                    this.myWatcher.add((IAEStack)this.configuredGas);
                }
                this.updateReportingValue(this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)));
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private <T extends IAEStack<T>> void updateReportingValue(IMEMonitor<T> monitor) {
        if (this.configuredGas != null) {
            IAEGasStack result = (IAEGasStack)monitor.getStorageList().findPrecise((IAEStack)this.configuredGas);
            this.configuredAmount = result == null ? 0L : result.getStackSize();
            this.configuredGas.setStackSize(this.configuredAmount);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, float partialTicks, int destroyStage) {
        if ((this.getClientFlags() & 0x14) != 20) {
            return;
        }
        IAEStack<?> ais = this.getDisplayed();
        if (ais == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        EnumFacing facing = this.getSide().getFacing();
        TesrRenderHelper.moveToFace((EnumFacing)facing);
        TesrRenderHelper.rotateToFace((EnumFacing)facing, (byte)this.getSpin());
        if (ais instanceof IAEGasStack) {
            GasRenderHelper.renderGas2dWithAmount((IAEGasStack)ais, 0.8f, 0.17f);
        }
        GlStateManager.func_179121_F();
    }

    public boolean requireDynamicRender() {
        return true;
    }

    public IAEStack<?> getDisplayed() {
        return this.configuredGas;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    @MENetworkEventSubscribe
    public void powerStatusChange(MENetworkPowerStatusChange ev) {
        if (this.getProxy().isPowered()) {
            this.configureWatchers();
        }
    }

    @MENetworkEventSubscribe
    public void channelChanged(MENetworkChannelsChanged c) {
        if (this.getProxy().isPowered()) {
            this.configureWatchers();
        }
    }

    public void onStackChange(IItemList<?> o, IAEStack<?> fullStack, IAEStack<?> diffStack, IActionSource src, IStorageChannel<?> chan) {
        this.configuredAmount = fullStack.getStackSize();
        if (this.configuredGas != null) {
            this.configuredGas.setStackSize(this.configuredAmount);
        }
        this.getHost().markForUpdate();
    }

    public boolean showNetworkInfo(RayTraceResult where) {
        return false;
    }

    protected IPartModel selectModel(IPartModel off, IPartModel on, IPartModel hasChannel, IPartModel lockedOff, IPartModel lockedOn, IPartModel lockedHasChannel) {
        if (this.isActive()) {
            if (this.isLocked()) {
                return lockedHasChannel;
            }
            return hasChannel;
        }
        if (this.isPowered()) {
            if (this.isLocked()) {
                return lockedOn;
            }
            return on;
        }
        if (this.isLocked()) {
            return lockedOff;
        }
        return off;
    }
}

