/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.common.part.reporting;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.helpers.PlayerSource;
import appeng.parts.PartModel;
import appeng.util.Platform;
import com.mekeng.github.MekEng;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.common.part.reporting.AbstractPartGasMonitor;
import com.mekeng.github.util.Utils;
import com.mekeng.github.util.helpers.ItemGasHandler;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class PartGasConversionMonitor
extends AbstractPartGasMonitor {
    public static final ResourceLocation MODEL_OFF = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_off");
    public static final ResourceLocation MODEL_ON = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_on");
    public static final ResourceLocation MODEL_LOCKED_OFF = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_locked_off");
    public static final ResourceLocation MODEL_LOCKED_ON = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_locked_on");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL});
    public static final IPartModel MODELS_LOCKED_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_LOCKED_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_LOCKED_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_LOCKED_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_HAS_CHANNEL});

    public PartGasConversionMonitor(ItemStack is) {
        super(is);
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions((DimensionalCoord)this.getLocation(), (EntityPlayer)player)) {
            return false;
        }
        ItemStack eq = player.func_184586_b(hand);
        GasStack gasInTank = null;
        ItemGasHandler itemGasHandler = Utils.getItemGasHandler(eq);
        if (itemGasHandler != null) {
            gasInTank = itemGasHandler.removeGas(Integer.MAX_VALUE, false);
        }
        if (this.isLocked()) {
            if (Platform.isWrench((EntityPlayer)player, (ItemStack)eq, (BlockPos)this.getLocation().getPos()) && (this.getDisplayed() == null || !this.getDisplayed().equals((Object)eq))) {
                return super.onPartActivate(player, hand, pos);
            }
            if (gasInTank != null && gasInTank.amount > 0 && this.getDisplayed() != null && this.getDisplayed().equals((Object)AEGasStack.of(gasInTank))) {
                this.drainGasContainer(player, hand);
            }
        }
        return super.onPartActivate(player, hand, pos);
    }

    public boolean onClicked(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions((DimensionalCoord)this.getLocation(), (EntityPlayer)player)) {
            return false;
        }
        if (this.getDisplayed() != null && this.getDisplayed() instanceof IAEGasStack) {
            this.fillGasContainer(player, hand);
        }
        return true;
    }

    private void drainGasContainer(EntityPlayer player, EnumHand hand) {
        try {
            GasStack drained;
            IMEMonitor cell;
            ItemStack held = player.func_184586_b(hand);
            if (held.func_190916_E() != 1) {
                return;
            }
            ItemGasHandler itemGasHandler = Utils.getItemGasHandler(held);
            if (itemGasHandler == null) {
                return;
            }
            GasStack extract = itemGasHandler.removeGas(Integer.MAX_VALUE, false);
            if (extract == null || extract.amount < 1) {
                return;
            }
            IEnergyGrid energy = this.getProxy().getEnergy();
            IAEGasStack notStorable = (IAEGasStack)Platform.poweredInsert((IEnergySource)energy, (IMEInventory)(cell = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class))), (IAEStack)AEGasStack.of(extract), (IActionSource)new PlayerSource(player, (IActionHost)this), (Actionable)Actionable.SIMULATE);
            if (notStorable != null && notStorable.getStackSize() > 0L) {
                int toStore = (int)((long)extract.amount - notStorable.getStackSize());
                GasStack storable = itemGasHandler.removeGas(toStore, false);
                if (storable == null || storable.amount == 0) {
                    return;
                }
                extract.amount = storable.amount;
            }
            if ((drained = itemGasHandler.removeGas(extract, true)) == null) {
                return;
            }
            extract.amount = drained.amount;
            IAEGasStack notInserted = (IAEGasStack)Platform.poweredInsert((IEnergySource)energy, (IMEInventory)cell, (IAEStack)AEGasStack.of(extract), (IActionSource)new PlayerSource(player, (IActionHost)this));
            if (notInserted != null && notInserted.getStackSize() > 0L) {
                MekEng.log.error("Gas item [%s] reported a different possible amount to drain than it actually provided.", (Object)held.func_82833_r());
            }
            player.func_184611_a(hand, itemGasHandler.getContainer());
        }
        catch (GridAccessException e) {
            MekEng.log.error((Object)e);
        }
    }

    private void fillGasContainer(EntityPlayer player, EnumHand hand) {
        try {
            ItemStack held = player.func_184586_b(hand);
            if (held.func_190916_E() != 1) {
                return;
            }
            ItemGasHandler itemGasHandler = Utils.getItemGasHandler(held);
            if (itemGasHandler == null) {
                return;
            }
            IAEGasStack stack = (IAEGasStack)this.getDisplayed().copy();
            stack.setStackSize(Integer.MAX_VALUE);
            int amountAllowed = itemGasHandler.addGas(stack.getGasStack(), false);
            stack.setStackSize(amountAllowed);
            IEnergyGrid energy = this.getProxy().getEnergy();
            IMEMonitor cell = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class));
            IAEGasStack canPull = (IAEGasStack)Platform.poweredExtraction((IEnergySource)energy, (IMEInventory)cell, (IAEStack)stack, (IActionSource)new PlayerSource(player, (IActionHost)this), (Actionable)Actionable.SIMULATE);
            if (canPull == null || canPull.getStackSize() < 1L) {
                return;
            }
            int canFill = itemGasHandler.addGas(canPull.getGasStack(), false);
            if (canFill == 0) {
                return;
            }
            stack.setStackSize(canFill);
            IAEGasStack pulled = (IAEGasStack)Platform.poweredExtraction((IEnergySource)energy, (IMEInventory)cell, (IAEStack)stack, (IActionSource)new PlayerSource(player, (IActionHost)this));
            if (pulled == null || pulled.getStackSize() < 1L) {
                MekEng.log.error("Unable to pull gas out of the ME system even though the simulation said yes ");
                return;
            }
            int used = itemGasHandler.addGas(pulled.getGasStack(), true);
            if (used != canFill) {
                MekEng.log.error("Gas item [%s] reported a different possible amount than it actually accepted.", (Object)held.func_82833_r());
            }
            player.func_184611_a(hand, itemGasHandler.getContainer());
        }
        catch (GridAccessException e) {
            MekEng.log.error((Object)e);
        }
    }

    @Nonnull
    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL, MODELS_LOCKED_OFF, MODELS_LOCKED_ON, MODELS_LOCKED_HAS_CHANNEL);
    }
}

