/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.network.packet;

import com.mekeng.github.MekEng;
import com.mekeng.github.common.container.sync.IGasSyncContainer;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.network.packet.MkEMessage;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;

public class CGasSlotSync
extends MkEMessage<CGasSlotSync> {
    protected Map<Integer, IAEGasStack> list;

    public CGasSlotSync() {
    }

    public CGasSlotSync(Map<Integer, IAEGasStack> list) {
        this.list = list;
    }

    @Override
    void toBytes(PacketBuffer buf) {
        NBTTagCompound HOLDER = new NBTTagCompound();
        for (Map.Entry<Integer, IAEGasStack> data : this.list.entrySet()) {
            NBTTagCompound gas = new NBTTagCompound();
            if (data.getValue() != null) {
                data.getValue().writeToNBT(gas);
            }
            HOLDER.func_74782_a(data.getKey().toString(), (NBTBase)gas);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)HOLDER);
    }

    @Override
    void fromBytes(PacketBuffer buf) {
        this.list = new Int2ObjectOpenHashMap();
        try {
            NBTTagCompound HOLDER = buf.func_150793_b();
            if (HOLDER != null) {
                for (String key : HOLDER.func_150296_c()) {
                    int id = Integer.parseInt(key);
                    IAEGasStack gas = AEGasStack.of(HOLDER.func_74775_l(key));
                    this.list.put(id, gas);
                }
            }
        }
        catch (IOException e) {
            MekEng.log.error("Fail to sync gas slot, it may cause ghost gas display");
            MekEng.log.error((Object)e);
        }
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public IMessageHandler<CGasSlotSync, IMessage> getHandler() {
        return (message, ctx) -> {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                if (player.field_71070_bA instanceof IGasSyncContainer) {
                    IGasSyncContainer c = (IGasSyncContainer)player.field_71070_bA;
                    c.receiveGasSlots(message.list);
                }
            });
            return null;
        };
    }
}

