/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.network.packet;

import com.mekeng.github.MekEng;
import com.mekeng.github.client.gui.GuiGasTerminal;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.network.packet.MkEMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;

public class SMEGasInventoryUpdate
extends MkEMessage<SMEGasInventoryUpdate> {
    private final PacketBuffer buffer = new PacketBuffer(Unpooled.buffer((int)1024));
    private final List<IAEGasStack> list = new ArrayList<IAEGasStack>();
    private int cnt = 0;

    public SMEGasInventoryUpdate addGas(IAEGasStack stack) {
        try {
            stack.writeToPacket((ByteBuf)this.buffer);
            ++this.cnt;
        }
        catch (IOException e) {
            this.buffer.clear();
            this.cnt = 0;
            MekEng.log.error((Object)e);
        }
        return this;
    }

    public boolean needFlush() {
        return this.buffer.readableBytes() > 0xE00000;
    }

    public void clear() {
        this.buffer.clear();
        this.cnt = 0;
    }

    public boolean isEmpty() {
        return this.cnt == 0;
    }

    @Override
    void toBytes(PacketBuffer buf) {
        buf.writeInt(this.cnt);
        buf.writeBytes((ByteBuf)this.buffer);
    }

    @Override
    void fromBytes(PacketBuffer buf) {
        this.cnt = buf.readInt();
        for (int i = 0; i < this.cnt; ++i) {
            this.list.add(AEGasStack.of((ByteBuf)buf));
        }
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public IMessageHandler<SMEGasInventoryUpdate, IMessage> getHandler() {
        return (message, ctx) -> {
            Minecraft.func_71410_x().func_152344_a(() -> {
                if (Minecraft.func_71410_x().field_71462_r instanceof GuiGasTerminal) {
                    ((GuiGasTerminal)Minecraft.func_71410_x().field_71462_r).postUpdate(message.list);
                }
            });
            return null;
        };
    }
}

