/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.network.packet.sync;

import com.mekeng.github.MekEng;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public final class ParaSerializer {
    public static void to(Object[] obj, ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        buffer.writeByte(obj.length);
        for (Object o : obj) {
            if (o == null) {
                buffer.writeByte(PT.VOID.ordinal());
                continue;
            }
            if (o instanceof Integer) {
                buffer.writeByte(PT.INT.ordinal());
                buffer.writeInt(((Integer)o).intValue());
                continue;
            }
            if (o instanceof Long) {
                buffer.writeByte(PT.LONG.ordinal());
                buffer.writeLong(((Long)o).longValue());
                continue;
            }
            if (o instanceof Short) {
                buffer.writeByte(PT.SHORT.ordinal());
                buffer.writeShort((int)((Short)o).shortValue());
                continue;
            }
            if (o instanceof Boolean) {
                buffer.writeByte(PT.BOOLEAN.ordinal());
                buffer.writeBoolean(((Boolean)o).booleanValue());
                continue;
            }
            if (o instanceof String) {
                buffer.writeByte(PT.STRING.ordinal());
                buffer.func_180714_a((String)o);
                continue;
            }
            if (o instanceof ItemStack) {
                buffer.writeByte(PT.STACK.ordinal());
                buffer.func_150788_a((ItemStack)o);
                continue;
            }
            if (o instanceof NBTTagCompound) {
                buffer.writeByte(PT.NBT.ordinal());
                buffer.func_150786_a((NBTTagCompound)o);
                continue;
            }
            if (o instanceof IAEGasStack) {
                buffer.writeByte(PT.AE_GAS_STACK.ordinal());
                try {
                    ((IAEGasStack)o).writeToPacket(buf);
                }
                catch (IOException e) {
                    MekEng.log.debug((Object)e);
                }
                continue;
            }
            throw new IllegalArgumentException("Args contains invalid type: " + o.getClass().getName());
        }
    }

    public static Object[] from(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        Object[] objs = new Object[buffer.readByte()];
        try {
            block13: for (int i = 0; i < objs.length; ++i) {
                switch (PT.values()[buffer.readByte()]) {
                    case VOID: {
                        objs[i] = null;
                        continue block13;
                    }
                    case INT: {
                        objs[i] = buffer.readInt();
                        continue block13;
                    }
                    case LONG: {
                        objs[i] = buffer.readLong();
                        continue block13;
                    }
                    case SHORT: {
                        objs[i] = buffer.readShort();
                        continue block13;
                    }
                    case BOOLEAN: {
                        objs[i] = buffer.readBoolean();
                        continue block13;
                    }
                    case STRING: {
                        objs[i] = buffer.func_150789_c(1024);
                        continue block13;
                    }
                    case STACK: {
                        objs[i] = buffer.func_150791_c();
                        continue block13;
                    }
                    case NBT: {
                        objs[i] = buffer.func_150793_b();
                        continue block13;
                    }
                    case AE_GAS_STACK: {
                        objs[i] = AEGasStack.of((ByteBuf)buffer);
                        continue block13;
                    }
                    default: {
                        throw new IllegalArgumentException("Args contains unknown type.");
                    }
                }
            }
        }
        catch (IOException e) {
            MekEng.log.debug((Object)e);
        }
        return objs;
    }

    private static enum PT {
        VOID,
        INT,
        LONG,
        SHORT,
        BOOLEAN,
        STRING,
        STACK,
        NBT,
        AE_GAS_STACK;

    }
}

