/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.util;

import appeng.container.interfaces.IInventorySlotAware;
import com.mekeng.github.common.container.handler.GuiFactory;
import com.mekeng.github.common.container.handler.GuiHandler;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.inventory.IExtendedGasHandler;
import com.mekeng.github.util.helpers.ItemGasHandler;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class Utils {
    public static GasStack getGasFromItem(ItemStack stack) {
        IGasItem gh = Utils.getGasHandler(stack);
        if (gh != null) {
            return gh.getGas(stack);
        }
        return null;
    }

    public static ItemGasHandler getItemGasHandler(ItemStack stack) {
        IGasItem handler = Utils.getGasHandler(stack);
        if (handler != null) {
            return new ItemGasHandler(handler, stack);
        }
        return null;
    }

    public static IGasItem getGasHandler(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IGasItem) {
            return (IGasItem)stack.func_77973_b();
        }
        return null;
    }

    public static String getGasModID(IAEGasStack stack) {
        return stack == null ? "** Null" : Utils.getGasModID(stack.getGasStack());
    }

    public static String getGasModID(GasStack stack) {
        Gas gas;
        if (stack != null && (gas = stack.getGas()) != null) {
            return gas.getIcon().func_110624_b();
        }
        return "** Null";
    }

    public static String getGasDisplayName(IAEGasStack stack) {
        return stack == null ? "** Null" : Utils.getGasDisplayName(stack.getGasStack());
    }

    public static String getGasDisplayName(GasStack stack) {
        Gas gas;
        if (stack != null && (gas = stack.getGas()) != null) {
            return gas.getLocalizedName();
        }
        return "** Null";
    }

    public static GasStack drawGas(IGasHandler handler, GasStack stack, EnumFacing side, int amount, boolean doTransfer) {
        if (handler instanceof IExtendedGasHandler) {
            GasStack draw = stack.copy().withAmount(amount);
            return ((IExtendedGasHandler)handler).drawGas(side, draw, doTransfer);
        }
        return handler.drawGas(side, amount, doTransfer);
    }

    public static void openItemGui(EntityPlayer player, GuiFactory<?> gui) {
        if (player.field_71070_bA instanceof IInventorySlotAware) {
            IInventorySlotAware c = (IInventorySlotAware)player.field_71070_bA;
            GuiHandler.openItemGui(player, player.field_70170_p, c.getInventorySlot(), c.isBaubleSlot(), gui);
        } else {
            GuiHandler.openItemGui(player, player.field_70170_p, player.field_71071_by.field_70461_c, false, gui);
        }
    }
}

