/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.util.helpers;

import appeng.api.config.IncludeExclude;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.localization.GuiText;
import com.mekeng.github.common.ItemAndBlocks;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.inventory.IGasInventory;
import com.mekeng.github.util.Utils;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.input.Keyboard;

public class GasCellInfo {
    private static final String[] NUMBER_FORMATS = new String[]{"#.000", "#.00", "#.0", "#"};

    public static <T extends IAEStack<T>> void addCellInformation(ICellInventoryHandler<T> handler, List<String> lines) {
        block10: {
            IItemList itemList;
            ICellInventory cellInventory;
            block9: {
                if (handler == null) {
                    return;
                }
                cellInventory = handler.getCellInv();
                if (cellInventory != null) {
                    lines.add(cellInventory.getUsedBytes() + " " + GuiText.Of.getLocal() + ' ' + cellInventory.getTotalBytes() + ' ' + GuiText.BytesUsed.getLocal());
                    lines.add(cellInventory.getStoredItemTypes() + " " + GuiText.Of.getLocal() + ' ' + cellInventory.getTotalItemTypes() + ' ' + GuiText.Types.getLocal());
                }
                if (cellInventory == null) {
                    return;
                }
                itemList = cellInventory.getChannel().createList();
                if (!handler.isPreformatted()) break block9;
                String list = (handler.getIncludeExcludeMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
                if (handler.isFuzzy()) {
                    lines.add("[" + GuiText.Partitioned.getLocal() + "] - " + list + ' ' + GuiText.Fuzzy.getLocal());
                } else {
                    lines.add("[" + GuiText.Partitioned.getLocal() + "] - " + list + ' ' + GuiText.Precise.getLocal());
                }
                if (handler.isSticky()) {
                    lines.add(GuiText.Sticky.getLocal());
                }
                if (!Minecraft.func_71410_x().field_71474_y.field_82882_x && !Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) break block10;
                IItemHandler inv = cellInventory.getConfigInventory();
                cellInventory.getAvailableItems(itemList);
                for (int i = 0; i < inv.getSlots(); ++i) {
                    ItemStack is = inv.getStackInSlot(i);
                    if (is.func_190926_b() || !(cellInventory.getChannel() instanceof IGasInventory)) continue;
                    AEGasStack ais = is.func_77973_b() == ItemAndBlocks.DUMMY_GAS ? AEGasStack.of(ItemAndBlocks.DUMMY_GAS.getGasStack(is)) : AEGasStack.of(Utils.getGasFromItem(is));
                    IAEGasStack stocked = (IAEGasStack)itemList.findPrecise((IAEStack)ais);
                    lines.add("[" + is.func_82833_r() + "]: " + (stocked == null ? "0" : GasCellInfo.gasStackSize(stocked.getStackSize())));
                }
                break block10;
            }
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x || Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                cellInventory.getAvailableItems(itemList);
                for (IAEStack s : itemList) {
                    if (!(s instanceof IAEGasStack)) continue;
                    lines.add(((IAEGasStack)s).getGasStack().getGas().getLocalizedName() + ": " + GasCellInfo.gasStackSize(s.getStackSize()));
                }
            }
        }
    }

    public static String gasStackSize(long size) {
        String unit = size >= 1000L ? "B" : "mB";
        int log = (int)Math.floor(Math.log10(size)) / 2;
        int index = Math.max(0, Math.min(3, log));
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat(NUMBER_FORMATS[index]);
        format.setDecimalFormatSymbols(symbols);
        format.setRoundingMode(RoundingMode.DOWN);
        String formatted = format.format((double)size / 1000.0);
        return formatted.concat(unit);
    }
}

