/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.util.helpers;

import com.mekeng.github.MekEng;
import com.mekeng.github.common.container.sync.IGasSyncContainer;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.inventory.IGasInventory;
import com.mekeng.github.common.me.inventory.impl.GasInventory;
import com.mekeng.github.network.packet.SGasSlotSync;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mekanism.api.gas.GasStack;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class GasSyncHelper {
    private final IGasInventory inv;
    private final IGasInventory cache;
    private final int idOffset;

    public static GasSyncHelper create(IGasInventory inv, int idOffset) {
        return new GasSyncHelper(inv, idOffset);
    }

    private GasSyncHelper(IGasInventory inv, int idOffset) {
        this.inv = inv;
        this.cache = new GasInventory(inv.size());
        this.idOffset = idOffset;
    }

    public void sendFull(Iterable<IContainerListener> listeners) {
        this.sendDiffMap(this.createDiffMap(true), listeners);
    }

    public void sendDiff(Iterable<IContainerListener> listeners) {
        this.sendDiffMap(this.createDiffMap(false), listeners);
    }

    public void readPacket(Map<Integer, IAEGasStack> data) {
        for (int i = 0; i < this.inv.size(); ++i) {
            if (!data.containsKey(i + this.idOffset)) continue;
            this.inv.setGas(i, data.get(i + this.idOffset) == null ? null : data.get(i + this.idOffset).getGasStack());
        }
    }

    private void sendDiffMap(Map<Integer, IAEGasStack> data, Iterable<IContainerListener> listeners) {
        if (data.isEmpty()) {
            return;
        }
        for (IContainerListener l : listeners) {
            if (!(l instanceof EntityPlayerMP)) continue;
            Container c = ((EntityPlayerMP)l).field_71070_bA;
            if (c instanceof IGasSyncContainer) {
                ((IGasSyncContainer)c).receiveGasSlots(data);
            }
            MekEng.proxy.netHandler.sendTo((IMessage)new SGasSlotSync(data), (EntityPlayerMP)l);
        }
    }

    private Map<Integer, IAEGasStack> createDiffMap(boolean full) {
        HashMap<Integer, IAEGasStack> ret = new HashMap<Integer, IAEGasStack>();
        for (int i = 0; i < this.inv.size(); ++i) {
            if (full || !this.equalsSlot(i)) {
                ret.put(i + this.idOffset, AEGasStack.of(this.inv.getGasStack(i)));
            }
            if (full) continue;
            this.cache.setGas(i, this.inv.getGasStack(i));
        }
        return ret;
    }

    private boolean equalsSlot(int slot) {
        GasStack stackB;
        GasStack stackA = this.inv.getGasStack(slot);
        if (!Objects.equals(stackA, stackB = this.cache.getGasStack(slot))) {
            return false;
        }
        return stackA == null || stackA.amount == stackB.amount;
    }
}

