/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.util.helpers;

import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.common.base.ITierItem;
import mekanism.common.tier.BaseTier;
import net.minecraft.item.ItemStack;

public class ItemGasHandler {
    private final IGasItem handler;
    private final ItemStack stack;

    public ItemGasHandler(IGasItem handler, ItemStack stack) {
        this.handler = handler;
        this.stack = stack;
    }

    public int addGas(@Nullable GasStack gas, boolean add) {
        if (gas == null || !this.handler.canReceiveGas(this.stack, gas.getGas())) {
            return 0;
        }
        int space = this.isCreative() ? Integer.MAX_VALUE : this.capacity() - this.gasAmount();
        int toAdd = Math.min(space, gas.amount);
        if (toAdd <= 0) {
            return 0;
        }
        if (add) {
            int newAmt = this.isCreative() ? Integer.MAX_VALUE : toAdd + this.gasAmount();
            this.handler.setGas(this.stack, gas.copy().withAmount(newAmt));
        }
        return toAdd;
    }

    @Nullable
    public GasStack removeGas(@Nullable GasStack gas, boolean drain) {
        if (gas == null || !this.handler.canProvideGas(this.stack, gas.getGas())) {
            return null;
        }
        return this.removeGas(gas.amount, drain);
    }

    public GasStack removeGas(int gas, boolean drain) {
        int left = this.isCreative() ? Integer.MAX_VALUE : this.gasAmount();
        int toRemove = Math.min(gas, left);
        if (toRemove <= 0 || this.handler.getGas(this.stack) == null) {
            return null;
        }
        GasStack removed = this.handler.getGas(this.stack).copy().withAmount(toRemove);
        if (drain && !this.isCreative()) {
            GasStack leftGas = removed.copy().withAmount(left - toRemove);
            if (leftGas.amount == 0) {
                leftGas = null;
            }
            this.handler.setGas(this.stack, leftGas);
        }
        return removed;
    }

    public int gasAmount() {
        GasStack gas = this.handler.getGas(this.stack);
        return gas == null ? 0 : gas.amount;
    }

    public GasStack gasStack() {
        return this.handler.getGas(this.stack);
    }

    public Gas gas() {
        GasStack gas = this.handler.getGas(this.stack);
        return gas == null ? null : gas.getGas();
    }

    public int capacity() {
        return this.handler.getMaxGas(this.stack);
    }

    public ItemStack getContainer() {
        return this.stack;
    }

    private boolean isCreative() {
        if (this.stack.func_77973_b() instanceof ITierItem) {
            return ((ITierItem)this.stack.func_77973_b()).getBaseTier(this.stack) == BaseTier.CREATIVE;
        }
        return false;
    }
}

