/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.util.helpers;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.IConfigManager;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.me.helpers.MEMonitorHandler;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.common.me.storage.IPortableGasCell;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PortableGasCellViewer
extends MEMonitorHandler<IAEGasStack>
implements IPortableGasCell,
IInventorySlotAware {
    private final ItemStack target;
    private final IAEItemPowerStorage ips;
    private final int inventorySlot;

    public PortableGasCellViewer(ItemStack is, int slot) {
        super((IMEInventoryHandler)AEApi.instance().registries().cell().getCellInventory(is, null, AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)));
        this.ips = (IAEItemPowerStorage)is.func_77973_b();
        this.target = is;
        this.inventorySlot = slot;
    }

    public int getInventorySlot() {
        return this.inventorySlot;
    }

    public ItemStack getItemStack() {
        return this.target;
    }

    public double extractAEPower(double amt, @Nonnull Actionable mode, PowerMultiplier usePowerMultiplier) {
        amt = usePowerMultiplier.multiply(amt);
        if (mode == Actionable.SIMULATE) {
            return usePowerMultiplier.divide(Math.min(amt, this.ips.getAECurrentPower(this.target)));
        }
        return usePowerMultiplier.divide(this.ips.extractAEPower(this.target, amt, Actionable.MODULATE));
    }

    public IAEGasStack injectItems(IAEGasStack input, Actionable mode, IActionSource src) {
        if (input == null || input.getStackSize() == 0L) {
            return null;
        }
        long size = input.getStackSize();
        IAEGasStack injected = (IAEGasStack)super.injectItems((IAEStack)input, mode, src);
        if (mode == Actionable.MODULATE && (injected == null || injected.getStackSize() != size)) {
            this.notifyListenersOfChange(Collections.singletonList(((IAEGasStack)input.copy()).setStackSize(input.getStackSize() - (injected == null ? 0L : injected.getStackSize()))), null);
        }
        return injected;
    }

    public IAEGasStack extractItems(IAEGasStack request, Actionable mode, IActionSource src) {
        if (request == null || request.getStackSize() == 0L) {
            return null;
        }
        IAEGasStack extractable = (IAEGasStack)super.extractItems((IAEStack)request, mode, src);
        if (mode == Actionable.MODULATE && extractable != null) {
            this.notifyListenersOfChange(Collections.singletonList(((IAEGasStack)request.copy()).setStackSize(-extractable.getStackSize())), null);
        }
        return extractable;
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        if (channel == AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class)) {
            return this;
        }
        return null;
    }

    public IConfigManager getConfigManager() {
        ConfigManager out = new ConfigManager((manager, settingName, newValue) -> {
            NBTTagCompound data = Platform.openNbtData((ItemStack)this.target);
            manager.writeToNBT(data);
        });
        out.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        out.readFromNBT(Platform.openNbtData((ItemStack)this.target).func_74737_b());
        return out;
    }
}

