/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.util.helpers;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.features.ILocatable;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.IUpgradeableCellHost;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.parts.automation.StackUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.networking.TileWireless;
import appeng.tile.qnb.TileQuantumBridge;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import com.mekeng.github.common.me.storage.IPortableGasCell;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class WirelessGasGuiObj
implements IPortableGasCell,
IActionHost,
IInventorySlotAware,
IAEAppEngInventory,
IUpgradeableCellHost {
    private final ItemStack effectiveItem;
    private final IWirelessTermHandler wth;
    private final String encryptionKey;
    private final EntityPlayer myPlayer;
    private final boolean isBaubleSlot;
    private IGrid targetGrid;
    private IStorageGrid sg;
    private IMEMonitor<IAEGasStack> gasStorage;
    private IWirelessAccessPoint myWap;
    private double sqRange = Double.MAX_VALUE;
    private double myRange = Double.MAX_VALUE;
    private final int inventorySlot;
    private final UpgradeInventory upgrades;
    private QuantumCluster myQC;

    public WirelessGasGuiObj(IWirelessTermHandler wh, ItemStack is, EntityPlayer ep, World w, int x, int y, int z) {
        IGridNode n;
        this.encryptionKey = wh.getEncryptionKey(is);
        this.effectiveItem = is;
        this.myPlayer = ep;
        this.wth = wh;
        this.inventorySlot = x;
        this.isBaubleSlot = y == 1;
        ILocatable obj = null;
        try {
            long encKey = Long.parseLong(this.encryptionKey);
            obj = AEApi.instance().registries().locatable().getLocatableBy(encKey);
        }
        catch (NumberFormatException encKey) {
            // empty catch block
        }
        if (obj instanceof IActionHost && (n = ((IActionHost)obj).getActionableNode()) != null) {
            this.targetGrid = n.getGrid();
            if (this.targetGrid != null) {
                this.sg = (IStorageGrid)this.targetGrid.getCache(IStorageGrid.class);
                if (this.sg != null) {
                    this.gasStorage = this.sg.getInventory(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class));
                }
            }
        }
        this.upgrades = new StackUpgradeInventory(this.effectiveItem, (IAEAppEngInventory)this, 2);
        this.loadFromNBT();
    }

    public double getRange() {
        return this.myRange;
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        return this.sg.getInventory(channel);
    }

    public void addListener(IMEMonitorHandlerReceiver<IAEGasStack> l, Object verificationToken) {
        if (this.gasStorage != null) {
            this.gasStorage.addListener(l, verificationToken);
        }
    }

    public void removeListener(IMEMonitorHandlerReceiver<IAEGasStack> l) {
        if (this.gasStorage != null) {
            this.gasStorage.removeListener(l);
        }
    }

    public IItemList<IAEGasStack> getAvailableItems(IItemList<IAEGasStack> out) {
        if (this.gasStorage != null) {
            return this.gasStorage.getAvailableItems(out);
        }
        return out;
    }

    public IItemList<IAEGasStack> getStorageList() {
        if (this.gasStorage != null) {
            return this.gasStorage.getStorageList();
        }
        return null;
    }

    public AccessRestriction getAccess() {
        if (this.gasStorage != null) {
            return this.gasStorage.getAccess();
        }
        return AccessRestriction.NO_ACCESS;
    }

    public boolean isPrioritized(IAEGasStack input) {
        if (this.gasStorage != null) {
            return this.gasStorage.isPrioritized((IAEStack)input);
        }
        return false;
    }

    public boolean canAccept(IAEGasStack input) {
        if (this.gasStorage != null) {
            return this.gasStorage.canAccept((IAEStack)input);
        }
        return false;
    }

    public int getPriority() {
        if (this.gasStorage != null) {
            return this.gasStorage.getPriority();
        }
        return 0;
    }

    public int getSlot() {
        if (this.gasStorage != null) {
            return this.gasStorage.getSlot();
        }
        return 0;
    }

    public boolean validForPass(int i) {
        return this.gasStorage.validForPass(i);
    }

    public IAEGasStack injectItems(IAEGasStack input, Actionable type, IActionSource src) {
        if (this.gasStorage != null) {
            return (IAEGasStack)this.gasStorage.injectItems((IAEStack)input, type, src);
        }
        return input;
    }

    public IAEGasStack extractItems(IAEGasStack request, Actionable mode, IActionSource src) {
        if (this.gasStorage != null) {
            return (IAEGasStack)this.gasStorage.extractItems((IAEStack)request, mode, src);
        }
        return null;
    }

    public IStorageChannel<IAEGasStack> getChannel() {
        if (this.gasStorage != null) {
            return this.gasStorage.getChannel();
        }
        return AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class);
    }

    public double extractAEPower(double amt, @Nonnull Actionable mode, @Nonnull PowerMultiplier usePowerMultiplier) {
        if (this.wth != null && this.effectiveItem != null) {
            if (mode == Actionable.SIMULATE) {
                return this.wth.hasPower(this.myPlayer, amt, this.effectiveItem) ? amt : 0.0;
            }
            return this.wth.usePower(this.myPlayer, amt, this.effectiveItem) ? amt : 0.0;
        }
        return 0.0;
    }

    public ItemStack getItemStack() {
        return this.effectiveItem;
    }

    public IConfigManager getConfigManager() {
        return this.wth.getConfigManager(this.effectiveItem);
    }

    @Nonnull
    public IGridNode getActionableNode() {
        this.rangeCheck();
        if (this.myWap != null) {
            return this.myWap.getActionableNode();
        }
        if (this.myQC != null && this.myQC.getCenter().isPowered()) {
            return this.myQC.getCenter().getActionableNode();
        }
        return null;
    }

    public boolean rangeCheck() {
        this.myRange = Double.MAX_VALUE;
        this.sqRange = Double.MAX_VALUE;
        if (this.targetGrid != null && this.gasStorage != null) {
            if (this.myWap != null) {
                if (this.myWap.getGrid() == this.targetGrid) {
                    return this.testWap(this.myWap);
                }
                return false;
            }
            IMachineSet tw = this.targetGrid.getMachines(TileWireless.class);
            this.myWap = null;
            this.myQC = null;
            for (IGridNode n : tw) {
                IWirelessAccessPoint wap = (IWirelessAccessPoint)n.getMachine();
                if (!this.testWap(wap)) continue;
                this.myWap = wap;
            }
            if (this.myWap != null) {
                return true;
            }
            tw = this.targetGrid.getMachines(TileQuantumBridge.class);
            for (IGridNode n : tw) {
                TileQuantumBridge center;
                TileQuantumBridge tqb = (TileQuantumBridge)n.getMachine();
                if (tqb.getCluster() == null || (center = ((QuantumCluster)tqb.getCluster()).getCenter()) == null || !center.getInternalInventory().getStackInSlot(1).func_77969_a((ItemStack)AEApi.instance().definitions().materials().cardQuantumLink().maybeStack(1).get())) continue;
                this.myQC = (QuantumCluster)tqb.getCluster();
                this.myRange = 1.0;
                return true;
            }
            return this.myWap != null || this.myQC != null;
        }
        return false;
    }

    private boolean testWap(IWirelessAccessPoint wap) {
        double offZ;
        double offY;
        double offX;
        double r;
        double rangeLimit = wap.getRange();
        rangeLimit *= rangeLimit;
        DimensionalCoord dc = wap.getLocation();
        if (dc.getWorld() == this.myPlayer.field_70170_p && (r = (offX = (double)dc.x - this.myPlayer.field_70165_t) * offX + (offY = (double)dc.y - this.myPlayer.field_70163_u) * offY + (offZ = (double)dc.z - this.myPlayer.field_70161_v) * offZ) < rangeLimit && this.sqRange > r && wap.isActive()) {
            this.sqRange = r;
            this.myRange = Math.sqrt(r);
            return true;
        }
        return false;
    }

    public int getInventorySlot() {
        return this.inventorySlot;
    }

    public boolean isBaubleSlot() {
        return this.isBaubleSlot;
    }

    public void saveChanges() {
        NBTTagCompound data = this.effectiveItem.func_77978_p();
        if (data == null) {
            data = new NBTTagCompound();
        }
        this.upgrades.writeToNBT(data, "upgrades");
    }

    public void saveChanges(NBTTagCompound data) {
        if (this.effectiveItem.func_77978_p() != null) {
            this.effectiveItem.func_77978_p().func_179237_a(data);
        } else {
            this.effectiveItem.func_77982_d(data);
        }
    }

    public void loadFromNBT() {
        NBTTagCompound data = this.effectiveItem.func_77978_p();
        if (data != null) {
            this.upgrades.readFromNBT(data);
        }
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    public IItemHandler getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }
}

