/*
 * Decompiled with CFR 0.152.
 */
package com.mekeng.github.xmod.nae;

import appeng.api.AEApi;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import co.neeve.nae2.common.helpers.exposer.AEStackExposerHandler;
import co.neeve.nae2.common.interfaces.IExposerHost;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.inventory.IExtendedGasHandler;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import java.util.Optional;
import javax.annotation.Nonnull;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import net.minecraft.util.EnumFacing;

public class GasExposerHandler
extends AEStackExposerHandler<IAEGasStack>
implements IExtendedGasHandler {
    private static final GasTankInfo[] EMPTY = new GasTankInfo[0];
    private GasTankInfo[] cachedProperties;

    public GasExposerHandler(IExposerHost host) {
        super(host);
    }

    protected IStorageChannel<IAEGasStack> getStorageChannel() {
        return AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class);
    }

    @Override
    public GasStack drawGas(EnumFacing side, GasStack resource, boolean doTransfer) {
        IAEGasStack pulled;
        AEGasStack aeStack;
        IAEGasStack stack;
        this.updateMonitor();
        IItemList storage = this.getStorageList();
        if (storage != null && (stack = (IAEGasStack)storage.findPrecise((IAEStack)(aeStack = AEGasStack.of(resource)))) != null && (pulled = (IAEGasStack)this.pullStack(aeStack, !doTransfer)) != null) {
            return pulled.getGasStack();
        }
        return null;
    }

    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        return 0;
    }

    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        Optional stack;
        IAEGasStack pulled;
        this.updateMonitor();
        if (!this.cache.isEmpty() && (pulled = (IAEGasStack)this.pullStack(((IAEGasStack)((IAEGasStack)(stack = this.cache.stream().findFirst()).get()).copy()).setStackSize(amount), !doTransfer)) != null) {
            return pulled.getGasStack();
        }
        return null;
    }

    protected void refreshCache() {
        super.refreshCache();
        this.rebuildProperties();
    }

    private void rebuildProperties() {
        if (this.cache.isEmpty()) {
            this.cachedProperties = null;
        } else {
            this.cachedProperties = new GasTankInfo[this.cache.size()];
            int i = 0;
            for (IAEGasStack cachedGas : this.cache) {
                GasTank info = new GasTank((int)cachedGas.getStackSize());
                info.setGas(cachedGas.getGasStack());
                this.cachedProperties[i++] = info;
            }
        }
    }

    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return false;
    }

    public boolean canDrawGas(EnumFacing side, Gas type) {
        return true;
    }

    @Nonnull
    public GasTankInfo[] getTankInfo() {
        this.updateMonitor();
        return this.cachedProperties != null ? this.cachedProperties : EMPTY;
    }
}

