/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.items;

import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.item.ItemMeta;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import com.blakebr0.mysticalagriculture.util.MystUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWateringCan
extends ItemMeta
implements IEnableable {
    private boolean water = false;
    private long ticks;
    public static ItemStack itemInferiumWateringCan;
    public static ItemStack itemPrudentiumWateringCan;
    public static ItemStack itemIntermediumWateringCan;
    public static ItemStack itemSuperiumWateringCan;
    public static ItemStack itemSupremiumWateringCan;

    public ItemWateringCan() {
        super("ma.watering_can", MysticalAgriculture.REGISTRY);
        this.func_77637_a(MysticalAgriculture.CREATIVE_TAB);
        this.func_77625_d(1);
    }

    public void init() {
        itemInferiumWateringCan = this.addItem(0, "inferium");
        itemPrudentiumWateringCan = this.addItem(1, "prudentium");
        itemIntermediumWateringCan = this.addItem(2, "intermedium");
        itemSuperiumWateringCan = this.addItem(3, "superium");
        itemSupremiumWateringCan = this.addItem(4, "supremium");
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (selected) {
            ++this.ticks;
            if (this.ticks % 4L == 0L) {
                this.water = true;
            }
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        if (!ModConfig.confFakePlayerWatering && player instanceof FakePlayer) {
            return EnumActionResult.FAIL;
        }
        if (this.water) {
            int range = stack.func_77960_j();
            Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range));
            for (BlockPos aoePos : blocks) {
                int moisture;
                IBlockState aoeState = world.func_180495_p(aoePos);
                if (!(aoeState.func_177230_c() instanceof BlockFarmland) || (moisture = ((Integer)aoeState.func_177229_b((IProperty)BlockFarmland.field_176531_a)).intValue()) >= 7) continue;
                world.func_180501_a(aoePos, aoeState.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 2);
            }
            Random rand = Utils.rand;
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    double d0 = (float)pos.func_177982_a(x, 0, z).func_177958_n() + rand.nextFloat();
                    double d1 = (double)pos.func_177982_a(x, 0, z).func_177956_o() + 1.0;
                    double d2 = (float)pos.func_177982_a(x, 0, z).func_177952_p() + rand.nextFloat();
                    IBlockState state = world.func_180495_p(pos);
                    if (state.func_185917_h() || state.func_177230_c() instanceof BlockFarmland) {
                        d1 += 0.3;
                    }
                    world.func_175688_a(EnumParticleTypes.WATER_DROP, d0, d1, d2, 0.0, 0.0, 0.0, new int[5]);
                }
            }
            if (!world.field_72995_K) {
                int bonus;
                this.water = false;
                int chance = Utils.randInt((int)1, (int)100);
                if (chance <= 40 + (bonus = 4 * stack.func_77960_j())) {
                    for (BlockPos aoePos : blocks) {
                        Block plant = world.func_180495_p(aoePos).func_177230_c();
                        if (!(plant instanceof IGrowable) && !(plant instanceof IPlantable) && plant != Blocks.field_150391_bh && plant != Blocks.field_185766_cS) continue;
                        world.func_180497_b(aoePos, plant, 0, 1000);
                    }
                    return EnumActionResult.FAIL;
                }
            }
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        int meta = stack.func_77960_j();
        int range = meta * 2 + 1;
        tooltip.add(Tooltips.RANGE + MystUtils.getColorFromMeta(meta) + range + "x" + range);
    }

    public boolean isEnabled() {
        return ModConfig.confWateringCans;
    }
}

