/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thelm.packagedauto.client.gui.GuiContainerTileBase;
import thelm.packagedauto.container.ContainerAmountSpecifying;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.PacketSetItemStack;

public class GuiAmountSpecifying
extends GuiContainerTileBase<ContainerAmountSpecifying> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/amount_specifying.png");
    private GuiContainerTileBase<?> parent;
    private int containerSlot;
    private ItemStack stack;
    private int maxAmount;
    protected GuiTextField amountField;

    public GuiAmountSpecifying(GuiContainerTileBase<?> parent, InventoryPlayer playerInventory, int containerSlot, ItemStack stack, int maxAmount) {
        super(new ContainerAmountSpecifying(playerInventory, stack));
        this.field_146999_f = 172;
        this.field_147000_g = 99;
        this.parent = parent;
        this.containerSlot = containerSlot;
        this.stack = stack;
        this.maxAmount = maxAmount;
    }

    protected int getDefaultAmount() {
        return this.stack.func_190916_E();
    }

    protected int getMaxAmount() {
        return this.maxAmount;
    }

    protected int[] getIncrements() {
        return new int[]{1, 10, 64};
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return BACKGROUND;
    }

    public void func_73866_w_() {
        String text;
        int increment;
        int i;
        this.field_146292_n.clear();
        super.func_73866_w_();
        this.func_189646_b(new ButtonSet(0, this.field_147003_i + 114, this.field_147009_r + 22, I18n.func_74838_a((String)"misc.packagedauto.set")));
        this.func_189646_b(new ButtonCancel(0, this.field_147003_i + 114, this.field_147009_r + 22 + 24, I18n.func_74838_a((String)"gui.cancel")));
        this.amountField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 9, this.field_147009_r + 51, 63, this.field_146289_q.field_78288_b);
        this.amountField.func_146185_a(false);
        this.amountField.func_146180_a(String.valueOf(this.getDefaultAmount()));
        this.amountField.func_146193_g(0xFFFFFF);
        this.amountField.func_175205_a(s -> {
            if (s.isEmpty()) {
                return true;
            }
            try {
                int amount = Integer.parseInt(s);
                return amount >= 0 && amount <= this.getMaxAmount();
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        this.amountField.func_146195_b(true);
        int[] increments = this.getIncrements();
        int xx = 7;
        for (i = 0; i < 3; ++i) {
            increment = increments[i];
            text = "+" + increment;
            this.func_189646_b(new ButtonIncrement(i, this.field_147003_i + xx, this.field_147009_r + 20, text));
            xx += 34;
        }
        xx = 7;
        for (i = 0; i < 3; ++i) {
            increment = increments[i];
            text = "-" + increment;
            this.func_189646_b(new ButtonIncrement(i + 3, this.field_147003_i + xx, this.field_147009_r + this.field_147000_g - 20 - 7, text));
            xx += 34;
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.amountField.func_146194_f();
    }

    protected void func_146979_b(int x, int y) {
        this.field_146289_q.func_78276_b(I18n.func_74838_a((String)"gui.packagedauto.amount_specifying"), 7, 7, 0x404040);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.close();
            return;
        }
        if ((keyCode == 28 || keyCode == 156) && this.amountField.func_146206_l()) {
            this.onOkButtonPressed(GuiAmountSpecifying.func_146272_n());
            return;
        }
        if (this.amountField.func_146201_a(typedChar, keyCode)) {
            return;
        }
        if (this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode) && this.amountField.func_146206_l()) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof ButtonSet) {
            this.onOkButtonPressed(GuiAmountSpecifying.func_146272_n());
        }
        if (button instanceof ButtonCancel) {
            this.close();
        }
        if (button instanceof ButtonIncrement) {
            int increment = this.getIncrements()[button.field_146127_k % 3];
            this.onIncrementButtonClicked(increment * (button.field_146127_k / 3 == 0 ? 1 : -1));
        }
    }

    protected void onIncrementButtonClicked(int increment) {
        int oldAmount = 0;
        try {
            oldAmount = Integer.parseInt(this.amountField.func_146179_b());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int newAmount = MathHelper.func_76125_a((int)(oldAmount + increment), (int)0, (int)this.getMaxAmount());
        this.amountField.func_146180_a(String.valueOf(newAmount));
    }

    protected void onOkButtonPressed(boolean shiftDown) {
        try {
            int amount = MathHelper.func_76125_a((int)Integer.parseInt(this.amountField.func_146179_b()), (int)0, (int)this.maxAmount);
            ItemStack newStack = this.stack.func_77946_l();
            newStack.func_190920_e(amount);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetItemStack((short)this.containerSlot, newStack));
            this.close();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void close() {
        this.field_146297_k.func_147108_a(this.parent);
    }

    public GuiContainerTileBase<?> getParent() {
        return this.parent;
    }

    class ButtonIncrement
    extends GuiButton {
        public ButtonIncrement(int buttonId, int x, int y, String text) {
            super(buttonId, x, y, 34, 20, text);
        }
    }

    class ButtonCancel
    extends GuiButton {
        public ButtonCancel(int buttonId, int x, int y, String text) {
            super(buttonId, x, y, 50, 20, text);
        }
    }

    class ButtonSet
    extends GuiButton {
        public ButtonSet(int buttonId, int x, int y, String text) {
            super(buttonId, x, y, 50, 20, text);
        }
    }
}

