/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import thelm.packagedauto.client.gui.GuiEncoder;
import thelm.packagedauto.integration.jei.EncoderGhostIngredientHandler;
import thelm.packagedauto.integration.jei.EncoderTransferHandler;

@JEIPlugin
public class PackagedAutoJEIPlugin
implements IModPlugin {
    public static IModRegistry registry;
    public static IJeiRuntime jeiRuntime;
    public static List<String> allCategories;

    public void register(IModRegistry registry) {
        PackagedAutoJEIPlugin.registry = registry;
        registry.getRecipeTransferRegistry().addUniversalRecipeTransferHandler((IRecipeTransferHandler)EncoderTransferHandler.INSTANCE);
        registry.addGhostIngredientHandler(GuiEncoder.class, (IGhostIngredientHandler)new EncoderGhostIngredientHandler());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        PackagedAutoJEIPlugin.jeiRuntime = jeiRuntime;
        allCategories = jeiRuntime.getRecipeRegistry().getRecipeCategories().stream().map(IRecipeCategory::getUid).collect(Collectors.toList());
    }

    public static List<String> getAllRecipeCategories() {
        return allCategories;
    }

    public static void showCategories(List<String> categories) {
        if (jeiRuntime != null && !categories.isEmpty()) {
            jeiRuntime.getRecipesGui().showCategories(categories);
        }
    }

    static {
        allCategories = Collections.emptyList();
    }
}

