/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IRecipeListItem;
import thelm.packagedauto.inventory.InventoryTileBase;
import thelm.packagedauto.tile.TileUnpackager;

public class InventoryUnpackager
extends InventoryTileBase {
    public final TileUnpackager tile;

    public InventoryUnpackager(TileUnpackager tile) {
        super(tile, 11);
        this.tile = tile;
        this.slots = IntStream.rangeClosed(0, 8).toArray();
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        if (index == 9) {
            this.updateRecipeList();
        } else if (index != 10) {
            this.clearRejectedIndexes();
        }
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = super.func_70298_a(index, count);
        if (index == 9) {
            this.updateRecipeList();
        } else if (index != 10) {
            this.clearRejectedIndexes();
        }
        return stack;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        switch (index) {
            case 9: {
                return stack.func_77973_b() instanceof IRecipeListItem;
            }
            case 10: {
                return stack.hasCapability(CapabilityEnergy.ENERGY, null);
            }
        }
        return stack.func_77973_b() instanceof IPackageItem;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id < 10) {
            return this.tile.trackers[id].getSyncValue();
        }
        switch (id) {
            case 10: {
                return this.tile.blocking ? 1 : 0;
            }
            case 11: {
                return this.tile.getEnergyStorage().getEnergyStored();
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id < 10) {
            this.tile.trackers[id].setSyncValue(value);
        }
        switch (id) {
            case 10: {
                this.tile.blocking = value != 0;
                break;
            }
            case 11: {
                this.tile.getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 12;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.updateRecipeList();
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index != 9 && index != 10;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index != 9 && index != 10 && direction == EnumFacing.UP && !Arrays.stream(this.tile.trackers).anyMatch(t -> t.isEmpty());
    }

    public void updateRecipeList() {
        this.tile.recipeList.clear();
        ItemStack listStack = this.func_70301_a(9);
        if (listStack.func_77973_b() instanceof IRecipeListItem) {
            this.tile.recipeList.addAll(((IRecipeListItem)listStack.func_77973_b()).getRecipeList(listStack).getRecipeList());
        }
        if (this.tile.func_145831_w() != null && !this.tile.func_145831_w().field_72995_K && this.tile.hostHelper != null) {
            this.tile.hostHelper.postPatternChange();
        }
    }

    public void clearRejectedIndexes() {
        for (TileUnpackager.PackageTracker tracker : this.tile.trackers) {
            tracker.clearRejectedIndexes();
        }
    }
}

