/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.tile;

import com.brandon3055.draconicevolution.api.fusioncrafting.ICraftingInjector;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionCraftingInventory;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import thelm.packagedauto.tile.TileBase;
import thelm.packageddraconic.block.BlockMarkedInjector;
import thelm.packageddraconic.energy.EnergyStorageMarkedInjector;
import thelm.packageddraconic.inventory.InventoryMarkedInjector;

public class TileMarkedInjector
extends TileBase
implements ICraftingInjector {
    public EnergyStorageMarkedInjector energyStorage = new EnergyStorageMarkedInjector(this);
    public BlockPos crafterPos = null;
    public int tier = -1;

    public TileMarkedInjector() {
        this.setInventory(new InventoryMarkedInjector(this));
    }

    protected String getLocalizedName() {
        return this.func_145838_q().func_149732_F();
    }

    public void spawnItem() {
        ItemStack stack = this.inventory.func_70301_a(0);
        this.inventory.func_70299_a(0, ItemStack.field_190927_a);
        if (!this.field_145850_b.field_72995_K && !stack.func_190926_b()) {
            EnumFacing facing = this.getDirection();
            double dx = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25 + (double)facing.func_82601_c() * 0.5;
            double dy = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25 + (double)facing.func_96559_d() * 0.5;
            double dz = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25 + (double)facing.func_82599_e() * 0.5;
            EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + dx, (double)this.field_174879_c.func_177956_o() + dy, (double)this.field_174879_c.func_177952_p() + dz, stack);
            entityitem.func_174869_p();
            this.field_145850_b.func_72838_d((Entity)entityitem);
        }
    }

    public int getPedestalTier() {
        Block block;
        if (this.tier == -1 && (block = this.func_145838_q()) instanceof BlockMarkedInjector) {
            this.tier = ((BlockMarkedInjector)block).tier;
        }
        return this.tier;
    }

    public ItemStack getStackInPedestal() {
        return this.inventory.func_70301_a(0);
    }

    public void setStackInPedestal(ItemStack stack) {
        this.inventory.func_70299_a(0, stack);
    }

    public boolean setCraftingInventory(IFusionCraftingInventory craftingInventory) {
        if (craftingInventory == null) {
            this.crafterPos = null;
            return false;
        }
        if (this.validateCraftingInventory() && !this.field_145850_b.field_72995_K) {
            return false;
        }
        this.crafterPos = ((TileEntity)craftingInventory).func_174877_v();
        return true;
    }

    public IFusionCraftingInventory getCraftingInventory() {
        TileEntity tile;
        this.validateCraftingInventory();
        if (this.crafterPos != null && (tile = this.field_145850_b.func_175625_s(this.crafterPos)) instanceof IFusionCraftingInventory) {
            return (IFusionCraftingInventory)tile;
        }
        return null;
    }

    public EnumFacing getDirection() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockMarkedInjector) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N);
        }
        return EnumFacing.UP;
    }

    public long getInjectorCharge() {
        return this.energyStorage.getExtendedEnergyStored();
    }

    public boolean validateCraftingInventory() {
        TileEntity tile;
        if (!this.getStackInPedestal().func_190926_b() && this.crafterPos != null && !(tile = this.field_145850_b.func_175625_s(this.crafterPos)).func_145837_r() && tile instanceof IFusionCraftingInventory && ((IFusionCraftingInventory)tile).craftingInProgress()) {
            return true;
        }
        this.crafterPos = null;
        return false;
    }

    public void onCraft() {
        if (this.crafterPos != null) {
            this.energyStorage.setEnergyStored(0L);
            this.crafterPos = null;
        }
    }

    public int getComparatorSignal() {
        return this.inventory.func_70301_a(0).func_190926_b() ? 0 : 15;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStorage.readFromNBT(nbt);
        this.crafterPos = null;
        if (nbt.func_74764_b("CrafterPos")) {
            int[] posArray = nbt.func_74759_k("CrafterPos");
            this.crafterPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.energyStorage.writeToNBT(nbt);
        if (this.crafterPos != null) {
            nbt.func_74783_a("CrafterPos", new int[]{this.crafterPos.func_177958_n(), this.crafterPos.func_177956_o(), this.crafterPos.func_177952_p()});
        }
        return nbt;
    }

    public void readSyncNBT(NBTTagCompound nbt) {
        super.readSyncNBT(nbt);
        this.inventory.readFromNBT(nbt);
    }

    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        super.writeSyncNBT(nbt);
        this.inventory.writeToNBT(nbt);
        return nbt;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return capability == CapabilityEnergy.ENERGY && this.getDirection() != from || super.hasCapability(capability, from);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY && this.getDirection() != facing ? this.energyStorage : super.getCapability(capability, facing));
    }

    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return null;
    }

    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return null;
    }
}

