/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.augment;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugment;
import thecodex6824.thaumicaugmentation.api.augment.IAugment;
import thecodex6824.thaumicaugmentation.api.augment.IAugmentableItem;

public class AugmentableItem
implements IAugmentableItem,
INBTSerializable<NBTTagCompound> {
    private ItemStack[] augments;

    public AugmentableItem(int slots) {
        this.augments = new ItemStack[slots];
        Arrays.fill(this.augments, 0, this.augments.length, ItemStack.field_190927_a);
    }

    public AugmentableItem(ItemStack[] augs) {
        this.augments = Arrays.copyOf(augs, augs.length);
        for (int i = 0; i < this.augments.length; ++i) {
            if (this.augments[i] != null) continue;
            this.augments[i] = ItemStack.field_190927_a;
        }
    }

    @Override
    public void setAugment(ItemStack augment, int slot) {
        if (slot > -1 && slot < this.augments.length) {
            this.augments[slot] = augment != null ? augment : ItemStack.field_190927_a;
        }
    }

    @Override
    public ItemStack[] setAllAugments(ItemStack[] augs) {
        ItemStack[] old = Arrays.copyOf(this.augments, this.augments.length);
        for (int i = 0; i < Math.min(this.augments.length, augs.length); ++i) {
            this.augments[i] = augs[i] != null ? augs[i] : ItemStack.field_190927_a;
        }
        return old;
    }

    @Override
    public ItemStack[] getAllAugments() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(this.augments.length);
        for (ItemStack stack : this.augments) {
            if (stack.func_190926_b()) continue;
            stacks.add(stack);
        }
        return stacks.toArray(new ItemStack[stacks.size()]);
    }

    @Override
    public ItemStack getAugment(int slot) {
        if (slot > -1 && slot < this.augments.length) {
            return this.augments[slot];
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack removeAugment(int slot) {
        if (slot > -1 && slot < this.augments.length) {
            ItemStack old = this.augments[slot];
            this.augments[slot] = ItemStack.field_190927_a;
            return old;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int getUsedAugmentSlots() {
        for (int i = 0; i < this.augments.length; ++i) {
            if (!this.augments[i].func_190926_b()) continue;
            return i;
        }
        return this.getTotalAugmentSlots();
    }

    @Override
    public int getTotalAugmentSlots() {
        return this.augments.length;
    }

    @Override
    public boolean isAugmentAcceptable(ItemStack augment, int slot) {
        for (ItemStack aug : this.augments) {
            if (aug.func_190926_b() || ((IAugment)aug.getCapability(CapabilityAugment.AUGMENT, null)).isCompatible(augment)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getNextAvailableSlot() {
        for (int i = 0; i < this.augments.length; ++i) {
            if (!this.augments[i].func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isAugmented() {
        for (ItemStack stack : this.augments) {
            if (stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound getSyncNBT() {
        return this.serializeNBT();
    }

    @Override
    public void readSyncNBT(NBTTagCompound tag) {
        this.deserializeNBT(tag);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("slots", this.augments.length);
        for (int i = 0; i < this.augments.length; ++i) {
            ItemStack stack = this.augments[i];
            if (stack == null || stack.func_190926_b()) continue;
            data.func_74782_a("slot" + i, (NBTBase)stack.serializeNBT());
        }
        return data;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt;
        int slots = data.func_74762_e("slots");
        if (slots < 256) {
            this.augments = new ItemStack[slots];
            for (int i = 0; i < this.augments.length; ++i) {
                this.augments[i] = data.func_150297_b("slot" + i, 10) ? new ItemStack(data.func_74775_l("slot" + i)) : ItemStack.field_190927_a;
            }
        }
    }
}

