/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.util;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.FMLCommonHandler;
import thaumcraft.api.casters.FocusModSplit;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.IFocusElement;
import thaumcraft.common.items.casters.foci.FocusEffectExchange;
import thaumcraft.common.items.casters.foci.FocusMediumBolt;
import thaumcraft.common.items.casters.foci.FocusMediumTouch;
import thaumcraft.common.items.casters.foci.FocusModSplitTarget;
import thaumcraft.common.items.casters.foci.FocusModSplitTrajectory;
import thecodex6824.thaumicaugmentation.common.item.foci.FocusEffectExchangeCompat;
import thecodex6824.thaumicaugmentation.common.item.foci.FocusMediumBoltCompat;
import thecodex6824.thaumicaugmentation.common.item.foci.FocusMediumTouchCompat;

public final class FocusUtils {
    private static final Field PACKAGE_POWER;

    private FocusUtils() {
    }

    public static void setPackagePower(FocusPackage fPackage, float newPower) {
        try {
            PACKAGE_POWER.setFloat(fPackage, newPower);
        }
        catch (Exception ex) {
            FMLCommonHandler.instance().raiseException((Throwable)ex, "Failed to set Thaumcraft's FocusPackage#power", true);
        }
    }

    public static float getPackagePower(FocusPackage fPackage) {
        return fPackage.getPower();
    }

    public static void replaceAndFixFoci(FocusPackage fPackage, EntityLivingBase caster) {
        List nodes = fPackage.nodes;
        for (int i = 0; i < nodes.size(); ++i) {
            IFocusElement element = (IFocusElement)nodes.get(i);
            if (element.getClass() == FocusMediumTouch.class) {
                nodes.set(i, new FocusMediumTouchCompat((FocusMediumTouch)element));
                continue;
            }
            if (element.getClass() == FocusMediumBolt.class) {
                nodes.set(i, new FocusMediumBoltCompat((FocusMediumBolt)element));
                continue;
            }
            if (element.getClass() == FocusEffectExchange.class) {
                nodes.set(i, new FocusEffectExchangeCompat((FocusEffectExchange)element));
                continue;
            }
            if (element.getClass() != FocusModSplitTarget.class && element.getClass() != FocusModSplitTrajectory.class) continue;
            FocusModSplit mod = (FocusModSplit)element;
            for (FocusPackage p : mod.getSplitPackages()) {
                p.setCasterUUID(fPackage.getCasterUUID());
                p.world = caster.func_130014_f_();
            }
        }
    }

    static {
        Field f = null;
        try {
            f = FocusPackage.class.getDeclaredField("power");
            f.setAccessible(true);
        }
        catch (Exception ex) {
            FMLCommonHandler.instance().raiseException((Throwable)ex, "Failed to access Thaumcraft's FocusPackage#power", true);
        }
        PACKAGE_POWER = f;
    }
}

