/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.ward.tile;

import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.eventhandler.Event;
import thecodex6824.thaumicaugmentation.api.event.WardedTilePermissionEvent;
import thecodex6824.thaumicaugmentation.api.item.CapabilityWardAuthenticator;
import thecodex6824.thaumicaugmentation.api.item.IWardAuthenticator;
import thecodex6824.thaumicaugmentation.api.ward.WardHelper;
import thecodex6824.thaumicaugmentation.api.ward.tile.IWardedTile;

public class WardedTile
implements IWardedTile,
INBTSerializable<NBTTagCompound> {
    protected static final UUID DEFAULT_UUID = new UUID(0L, 0L);
    protected UUID owner = DEFAULT_UUID;
    protected WeakReference<TileEntity> tile;

    public WardedTile(TileEntity t) {
        this.tile = new WeakReference<TileEntity>(t);
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(UUID uuid) {
        this.owner = uuid;
    }

    @Override
    public String getUniqueTypeID() {
        return this.tile.get() != null ? TileEntity.func_190559_a(((TileEntity)this.tile.get()).getClass()).toString() : "";
    }

    @Override
    public BlockPos getPosition() {
        return this.tile.get() != null ? ((TileEntity)this.tile.get()).func_174877_v() : BlockPos.field_177992_a;
    }

    protected boolean checkPermission(EntityLivingBase entity) {
        if (entity == null) {
            return false;
        }
        if (this.owner.equals(entity.func_110124_au())) {
            return true;
        }
        if (WardHelper.doesEntityHaveSpecialPermission(entity)) {
            return true;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack stack = null;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                stack = player.field_71071_by.func_70301_a(i);
                IWardAuthenticator auth = (IWardAuthenticator)stack.getCapability(CapabilityWardAuthenticator.WARD_AUTHENTICATOR, null);
                if (auth == null || !auth.permitsUsage(this, stack, entity)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasPermission(EntityLivingBase player) {
        if (this.tile.get() != null) {
            TileEntity t = (TileEntity)this.tile.get();
            WardedTilePermissionEvent event = new WardedTilePermissionEvent(t.func_145831_w(), t.func_174877_v(), t.func_145831_w().func_180495_p(t.func_174877_v()), player, this.checkPermission(player));
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                switch (event.getResult()) {
                    case ALLOW: {
                        return true;
                    }
                    case DENY: {
                        return false;
                    }
                }
                return event.isAllowed();
            }
        }
        return false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_186854_a("owner", this.owner);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.owner = nbt.func_150297_b("owner", 8) ? UUID.fromString(nbt.func_74779_i("owner")) : nbt.func_186857_a("owner");
    }
}

