/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.model;

import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import thecodex6824.thaumicaugmentation.client.model.MorphicArmorBakedModel;
import thecodex6824.thaumicaugmentation.client.model.MorphicArmorExclusions;

@Mod.EventBusSubscriber(modid="thaumicaugmentation", value={Side.CLIENT})
public class MiscModels {
    protected static final ResourceLocation SHIELD_MODEL = new ResourceLocation("thaumicaugmentation", "block/impetus_gate_shield");
    protected static final ModelResourceLocation SHIELD_MODEL_LOC = new ModelResourceLocation(SHIELD_MODEL, "normal");
    protected static final HashMap<ModelResourceLocation, ModelResourceLocation> ARMOR_REPLACEMENTS = new HashMap();
    protected static ModelManager manager;

    public static IBakedModel getImpetusGateShieldModel() {
        if (manager == null) {
            manager = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b();
        }
        return manager.func_174953_a(SHIELD_MODEL_LOC);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onModelBake(ModelBakeEvent event) {
        IRegistry registry = event.getModelRegistry();
        IModel shield = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)SHIELD_MODEL);
        IBakedModel shieldModel = shield.bake(shield.getDefaultState(), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
        registry.func_82595_a((Object)SHIELD_MODEL_LOC, (Object)shieldModel);
        ModelLoader loader = event.getModelLoader();
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof ItemArmor)) continue;
            for (String s : loader.func_177596_a(item)) {
                ModelResourceLocation model = ModelLoader.getInventoryVariant((String)s);
                if (MorphicArmorExclusions.isModelExcluded(model.toString())) continue;
                IBakedModel old = (IBakedModel)registry.func_82594_a((Object)model);
                registry.func_82595_a((Object)model, (Object)new MorphicArmorBakedModel(old));
                ModelResourceLocation oldLoc = new ModelResourceLocation("thaumicaugmentation_" + model.func_110624_b() + ":" + model.func_110623_a(), model.func_177518_c());
                registry.func_82595_a((Object)oldLoc, (Object)old);
                ARMOR_REPLACEMENTS.put(model, oldLoc);
            }
        }
    }

    public static ModelResourceLocation getOriginalArmorModel(ModelResourceLocation loc) {
        return ARMOR_REPLACEMENTS.getOrDefault(loc, ModelBakery.field_177604_a);
    }
}

