/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.model;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ItemModelMesherForge;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.client.model.MiscModels;
import thecodex6824.thaumicaugmentation.client.renderer.item.MorphicArmorWrappingTEISR;
import thecodex6824.thaumicaugmentation.client.renderer.item.MorphicWrappingTEISR;
import thecodex6824.thaumicaugmentation.common.util.MorphicArmorHelper;

public class MorphicArmorBakedModel
implements IBakedModel {
    protected static final HashSet<ResourceLocation> WARNED_ITEMS = new HashSet();
    protected IBakedModel wrappedFallback;
    protected ModelResourceLocation wrappedLoc;
    protected ItemOverrideList handler;

    public MorphicArmorBakedModel(IBakedModel wrappedModel) {
        this.wrappedFallback = wrappedModel;
        this.handler = new ItemOverrideList((List)ImmutableList.of()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                IBakedModel model = null;
                ItemStack disp = MorphicArmorHelper.getMorphicArmor(stack);
                if (disp.func_190926_b()) {
                    model = MorphicArmorBakedModel.this.wrappedFallback.func_188617_f().handleItemState(MorphicArmorBakedModel.this.wrappedFallback, stack, world, entity);
                    disp = stack;
                } else {
                    if (!(stack.func_77973_b().getTileEntityItemStackRenderer() instanceof MorphicWrappingTEISR)) {
                        stack.func_77973_b().setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new MorphicArmorWrappingTEISR(stack.func_77973_b().getTileEntityItemStackRenderer()));
                    }
                    model = Minecraft.func_71410_x().func_175599_af().func_184393_a(disp, world, entity);
                }
                try {
                    for (int i = 0; i < 10; ++i) {
                        IBakedModel next = model.func_188617_f().handleItemState(model, disp, world, entity);
                        if (next == model) {
                            return model;
                        }
                        model = next;
                    }
                }
                catch (Throwable ex) {
                    if (WARNED_ITEMS.add(stack.func_77973_b().getRegistryName())) {
                        ThaumicAugmentation.getLogger().debug("Model for armor item {} threw an exception", (Object)stack.func_77973_b().getRegistryName());
                        ThaumicAugmentation.getLogger().catching(Level.DEBUG, ex);
                    }
                    return model;
                }
                if (WARNED_ITEMS.add(stack.func_77973_b().getRegistryName())) {
                    ThaumicAugmentation.getLogger().debug("Model for armor item {} was too recursive, this might be a bug", (Object)stack.func_77973_b().getRegistryName());
                }
                return model;
            }

            @Nullable
            public ResourceLocation func_188021_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                ItemModelMesher m = Minecraft.func_71410_x().func_175599_af().func_175037_a();
                ItemStack disp = MorphicArmorHelper.getMorphicArmor(stack);
                if (!disp.func_190926_b()) {
                    ResourceLocation r = m.func_178089_a(disp).func_188617_f().func_188021_a(disp, world, entity);
                    if (r == null) {
                        r = MiscModels.getOriginalArmorModel(((ItemModelMesherForge)m).getLocation(disp));
                    }
                    return r;
                }
                ResourceLocation r = MorphicArmorBakedModel.this.wrappedFallback.func_188617_f().func_188021_a(stack, world, entity);
                if (r == null) {
                    r = MiscModels.getOriginalArmorModel(((ItemModelMesherForge)m).getLocation(stack));
                }
                return r;
            }
        };
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return Collections.emptyList();
    }

    public ItemOverrideList func_188617_f() {
        return this.handler;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.wrappedFallback.func_177554_e();
    }

    public boolean func_177555_b() {
        return this.wrappedFallback.func_177555_b();
    }

    public boolean func_188618_c() {
        return this.wrappedFallback.func_188618_c();
    }

    public boolean func_177556_c() {
        return this.wrappedFallback.func_177556_c();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.wrappedFallback.func_177552_f();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)this.wrappedFallback.handlePerspective(cameraTransformType).getValue());
    }
}

