/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.event;

import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.block.property.IWardParticles;
import thecodex6824.thaumicaugmentation.api.event.BlockWardEvent;
import thecodex6824.thaumicaugmentation.api.ward.WardHelper;
import thecodex6824.thaumicaugmentation.api.ward.WardSyncManager;
import thecodex6824.thaumicaugmentation.api.ward.storage.CapabilityWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageServer;
import thecodex6824.thaumicaugmentation.common.network.PacketFullWardSync;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.PacketWardUpdate;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

public class WardEventHandler {
    protected static void sendWardParticles(World world, BlockPos pos, EnumFacing facing) {
        if (!world.field_72995_K) {
            TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.WARD, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), facing.func_176745_a()), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0));
        }
    }

    protected static boolean isPlayerInChunkRange(WardSyncManager.DimensionalChunkPos pos, EntityPlayerMP player) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(pos.dim).func_184164_w().func_72694_a(player, pos.x, pos.z);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (Map.Entry<WardSyncManager.DimensionalChunkPos, WardSyncManager.WardUpdateEntry> entry : WardSyncManager.getEntries()) {
                Chunk chunk;
                IWardStorage storage;
                WardSyncManager.DimensionalChunkPos pos = entry.getKey();
                if (entry.getValue().update != null) {
                    for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                        if (player.field_71093_bK != pos.dim || !WardEventHandler.isPlayerInChunkRange(pos, player)) continue;
                        byte send = 0;
                        if (entry.getValue().update.equals(player.func_110124_au())) {
                            send = 1;
                        } else if (!entry.getValue().update.equals(IWardStorageServer.NIL_UUID)) {
                            send = 2;
                        }
                        TANetwork.INSTANCE.sendTo((IMessage)new PacketWardUpdate(entry.getValue().pos, send), player);
                    }
                    continue;
                }
                WorldServer world = DimensionManager.getWorld((int)pos.dim);
                if (world == null || !world.func_175667_e(entry.getValue().pos) || !((storage = (IWardStorage)(chunk = world.func_72964_e(pos.x, pos.z)).getCapability(CapabilityWardStorage.WARD_STORAGE, null)) instanceof IWardStorageServer)) continue;
                for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                    NBTTagCompound sync;
                    if (player.field_71093_bK != pos.dim || !WardEventHandler.isPlayerInChunkRange(pos, player) || (sync = ((IWardStorageServer)storage).fullSyncToClient(chunk, player.func_110124_au(), true)) == null) continue;
                    TANetwork.INSTANCE.sendTo((IMessage)new PacketFullWardSync(sync), player);
                }
            }
            WardSyncManager.clearEntries();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onTrackChunk(ChunkWatchEvent.Watch event) {
        NBTTagCompound sync;
        IWardStorage storage;
        if (event.getChunkInstance() != null && event.getPlayer() != null && (storage = (IWardStorage)event.getChunkInstance().getCapability(CapabilityWardStorage.WARD_STORAGE, null)) instanceof IWardStorageServer && (sync = ((IWardStorageServer)storage).fullSyncToClient(event.getChunkInstance(), event.getPlayer().func_110124_au())) != null) {
            TANetwork.INSTANCE.sendTo((IMessage)new PacketFullWardSync(sync), event.getPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.START && !TAConfig.disableExpensiveWardFeatures.getValue().booleanValue() && event.world instanceof WorldServer) {
            WorldServer world = (WorldServer)event.world;
            try {
                Iterator iterator = world.field_73064_N.iterator();
                while (iterator.hasNext()) {
                    IWardStorage storage;
                    NextTickListEntry entry = (NextTickListEntry)iterator.next();
                    Chunk chunk = (Chunk)world.func_72863_F().field_73244_f.get(ChunkPos.func_77272_a((int)(entry.field_180282_a.func_177958_n() >> 4), (int)(entry.field_180282_a.func_177952_p() >> 4)));
                    if (chunk == null || (storage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null)) == null || !storage.hasWard(entry.field_180282_a)) continue;
                    iterator.remove();
                    world.field_73065_O.remove(entry);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockPos pos = event.getPos();
        Chunk chunk = event.getWorld().func_175726_f(pos);
        IWardStorage storage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null);
        if (storage != null && storage.hasWard(pos)) {
            if (!WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)event.getPlayer())) {
                event.setCanceled(true);
            } else if (storage instanceof IWardStorageServer) {
                ((IWardStorageServer)storage).clearWard(pos, event.getWorld());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockPunch(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos = event.getPos();
        Chunk chunk = event.getWorld().func_175726_f(pos);
        IWardStorage storage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null);
        if (storage != null) {
            if (storage.hasWard(pos) && !WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)event.getEntityPlayer())) {
                EntityPlayer player = event.getEntityPlayer();
                RayTraceResult ray = player.func_130014_f_().func_147447_a(player.func_174824_e(1.0f), player.func_70040_Z().func_186678_a(player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e()).func_178787_e(new Vec3d((Vec3i)pos)), false, false, true);
                WardEventHandler.sendWardParticles(event.getEntityPlayer().func_130014_f_(), pos, ray.field_178784_b);
                event.setCanceled(true);
            } else if (event.getWorld().func_180495_p(pos).func_177230_c() instanceof IWardParticles && !WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)event.getEntityPlayer())) {
                EntityPlayer player = event.getEntityPlayer();
                IBlockState state = event.getWorld().func_180495_p(pos);
                if (((IWardParticles)state.func_177230_c()).shouldAddWardParticles(event.getWorld(), pos, state, player)) {
                    RayTraceResult ray = player.func_130014_f_().func_147447_a(player.func_174824_e(1.0f), player.func_70040_Z().func_186678_a(player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e()).func_178787_e(new Vec3d((Vec3i)pos)), false, false, true);
                    WardEventHandler.sendWardParticles(event.getEntityPlayer().func_130014_f_(), pos, ray.field_178784_b);
                    if (((IWardParticles)state.func_177230_c()).shouldCancelEventAndContinueParticles(event.getWorld(), pos, state, player)) {
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        Chunk chunk = event.getWorld().func_175726_f(pos);
        IWardStorage storage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null);
        if (storage != null && storage.hasWard(pos) && !WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)event.getEntityPlayer())) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        if (!TAConfig.disableExpensiveWardFeatures.getValue().booleanValue() && event.getWorld().func_175667_e(event.getPos()) && event.getWorld().func_190526_b(event.getPos().func_177958_n() >> 4, event.getPos().func_177952_p() >> 4)) {
            Chunk chunk;
            IWardStorage storage;
            BlockPos notifier = event.getPos();
            EnumSet<EnumFacing> sidesToRemove = EnumSet.noneOf(EnumFacing.class);
            for (EnumFacing facing : event.getNotifiedSides()) {
                Chunk chunk2;
                IWardStorage storage2;
                BlockPos pos = notifier.func_177972_a(facing);
                if (!event.getWorld().func_190526_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) || event.getWorld().func_175623_d(pos) || (storage2 = (IWardStorage)(chunk2 = event.getWorld().func_175726_f(pos)).getCapability(CapabilityWardStorage.WARD_STORAGE, null)) == null || !storage2.hasWard(pos)) continue;
                sidesToRemove.add(facing);
            }
            event.getNotifiedSides().removeAll(sidesToRemove);
            TileEntity check = event.getWorld().func_175625_s(event.getPos());
            if ((event.getWorld().func_175623_d(event.getPos()) || !WardHelper.isTileWardAllowed(check)) && (storage = (IWardStorage)(chunk = event.getWorld().func_175726_f(event.getPos())).getCapability(CapabilityWardStorage.WARD_STORAGE, null)) instanceof IWardStorageServer && storage.hasWard(event.getPos())) {
                ((IWardStorageServer)storage).clearWard(event.getPos(), event.getWorld());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (!(event instanceof BlockEvent.MultiPlaceEvent)) {
            BlockPos pos = event.getPos();
            Chunk chunk = event.getWorld().func_175726_f(pos);
            IWardStorage storage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null);
            if (storage != null && storage instanceof IWardStorageServer && storage.hasWard(event.getPos())) {
                ((IWardStorageServer)storage).clearWard(event.getPos(), event.getWorld());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockPlaceMulti(BlockEvent.MultiPlaceEvent event) {
        for (BlockSnapshot b : event.getReplacedBlockSnapshots()) {
            BlockPos pos = b.getPos();
            Chunk chunk = event.getWorld().func_175726_f(pos);
            IWardStorage storage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null);
            if (storage == null || !storage.hasWard(pos)) continue;
            if (!(event.getEntity() instanceof EntityPlayer) || !WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)((EntityPlayer)event.getEntity()))) {
                event.setCanceled(true);
                return;
            }
            if (!(storage instanceof IWardStorageServer)) continue;
            ((IWardStorageServer)storage).clearWard(pos, event.getWorld());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onDestruction(LivingDestroyBlockEvent event) {
        BlockPos pos = event.getPos();
        Chunk chunk = event.getEntity().func_130014_f_().func_175726_f(pos);
        IWardStorage storage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null);
        if (storage != null && storage.hasWard(pos)) {
            if (!(event.getEntity() instanceof EntityPlayer) || !WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)((EntityPlayer)event.getEntity()))) {
                event.setCanceled(true);
            } else if (storage instanceof IWardStorageServer) {
                ((IWardStorageServer)storage).clearWard(pos, event.getEntity().func_130014_f_());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBonemeal(BonemealEvent event) {
        BlockPos pos = event.getPos();
        Chunk chunk = event.getWorld().func_175726_f(pos);
        IWardStorage storage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null);
        if (storage != null && storage.hasWard(pos) && !WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onHoe(UseHoeEvent event) {
        BlockPos pos = event.getPos();
        Chunk chunk = event.getWorld().func_175726_f(pos);
        IWardStorage storage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null);
        if (storage != null && storage.hasWard(pos) && !WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onTrample(BlockEvent.FarmlandTrampleEvent event) {
        BlockPos pos = event.getPos();
        Chunk chunk = event.getWorld().func_175726_f(pos);
        IWardStorage storage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null);
        if (!(storage == null || !storage.hasWard(pos) || event.getEntity() instanceof EntityPlayer && WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)((EntityPlayer)event.getEntity())))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onFluidPlaceBlock(BlockEvent.FluidPlaceBlockEvent event) {
        BlockPos pos = event.getPos();
        Chunk chunk = event.getWorld().func_175726_f(pos);
        IWardStorage storage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null);
        if (storage != null && storage.hasWard(pos)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWardBlock(BlockWardEvent.WardedServer.Post event) {
        event.getWorld().func_175646_b(event.getPos(), null);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDewardBlock(BlockWardEvent.DewardedServer.Post event) {
        event.getWorld().func_190524_a(event.getPos(), event.getWorld().func_180495_p(event.getPos().func_177984_a()).func_177230_c(), event.getPos().func_177984_a());
        event.getWorld().func_175684_a(event.getPos(), event.getWorld().func_180495_p(event.getPos()).func_177230_c(), event.getWorld().func_180495_p(event.getPos()).func_177230_c().func_149738_a(event.getWorld()));
        event.getWorld().func_175646_b(event.getPos(), null);
    }
}

