/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.math.DoubleMath;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.casters.IInteractWithCaster;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.ConsumeResult;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.NodeHelper;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.SimpleImpetusConsumer;
import thecodex6824.thaumicaugmentation.api.item.CapabilityBiomeSelector;
import thecodex6824.thaumicaugmentation.api.item.IBiomeSelector;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.PacketTerraformerWork;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.world.biome.BiomeUtil;

public class TileArcaneTerraformer
extends TileEntity
implements IInteractWithCaster,
ITickable,
IEssentiaTransport {
    protected static final int MAX_ESSENTIA = 30;
    protected static final Cache<Biome, Object2IntOpenHashMap<Aspect>> BIOME_COSTS = CacheBuilder.newBuilder().softValues().concurrencyLevel(1).build();
    protected static final EnumFacing[] VALID_SIDES = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    protected ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileArcaneTerraformer.this.func_70296_d();
            TileArcaneTerraformer.this.field_145850_b.func_184138_a(TileArcaneTerraformer.this.field_174879_c, TileArcaneTerraformer.this.field_145850_b.func_180495_p(TileArcaneTerraformer.this.field_174879_c), TileArcaneTerraformer.this.field_145850_b.func_180495_p(TileArcaneTerraformer.this.field_174879_c), 2);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.hasCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    protected SimpleImpetusConsumer consumer = new SimpleImpetusConsumer(1, 0);
    protected int radius = 16;
    protected ResourceLocation activeBiome;
    protected BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(0, 0, 0);
    protected int blocksChecked;
    protected boolean impetusPaid;
    protected boolean essentiaPaid;
    protected boolean visPaid;
    protected Object2IntOpenHashMap<Aspect> essentia = new Object2IntOpenHashMap(5);
    protected HashSet<ChunkPos> chunks = new HashSet();
    protected boolean circle = true;
    protected int ticks = ThreadLocalRandom.current().nextInt(20);

    @Nullable
    public EnumFacing getSideForAspect(Aspect aspect) {
        if (aspect == Aspect.EXCHANGE) {
            return EnumFacing.DOWN;
        }
        if (aspect == Aspect.FIRE) {
            return EnumFacing.WEST;
        }
        if (aspect == Aspect.AIR) {
            return EnumFacing.NORTH;
        }
        if (aspect == Aspect.WATER) {
            return EnumFacing.EAST;
        }
        if (aspect == Aspect.EARTH) {
            return EnumFacing.SOUTH;
        }
        return null;
    }

    @Nullable
    public Aspect getAspectForSide(EnumFacing side) {
        return this.getAspectForSide(side.func_176745_a());
    }

    @Nullable
    public Aspect getAspectForSide(int side) {
        switch (side) {
            case 0: {
                return Aspect.EXCHANGE;
            }
            case 2: {
                return Aspect.AIR;
            }
            case 3: {
                return Aspect.EARTH;
            }
            case 4: {
                return Aspect.FIRE;
            }
            case 5: {
                return Aspect.WATER;
            }
        }
        return null;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(Math.min(radius, 32), 1);
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        }
    }

    public boolean isCircle() {
        return this.circle;
    }

    public void setCircle(boolean circle) {
        this.circle = circle;
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        }
    }

    public boolean isRunning() {
        return this.activeBiome != null;
    }

    @Nullable
    public ResourceLocation getActiveBiome() {
        return this.activeBiome;
    }

    public boolean onCasterRightClick(World world, ItemStack stack, EntityPlayer player, BlockPos pos, EnumFacing facing, EnumHand hand) {
        if (!world.field_72995_K) {
            if (this.activeBiome == null) {
                IBiomeSelector selected;
                ItemStack inv = this.inventory.getStackInSlot(0);
                if (!inv.func_190926_b() && (selected = (IBiomeSelector)inv.getCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null)) != null) {
                    this.activeBiome = selected.getBiomeID();
                    this.currentPos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    this.blocksChecked = 0;
                    this.chunks.clear();
                    this.func_70296_d();
                    world.func_184133_a(null, pos, SoundsTC.craftstart, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 2);
                }
            } else {
                this.endTerraforming(true);
            }
        }
        return true;
    }

    public void endTerraforming(boolean fail) {
        if (this.activeBiome != null) {
            this.activeBiome = null;
            this.currentPos.func_181079_c(0, 0, 0);
            this.blocksChecked = 0;
            for (ChunkPos c : this.chunks) {
                BlockPos base = new BlockPos(c.func_180334_c(), this.field_174879_c.func_177956_o(), c.func_180333_d());
                BiomeUtil.generateNewAura(this.field_145850_b, base, true);
                for (EnumFacing f : EnumFacing.field_176754_o) {
                    BiomeUtil.generateNewAura(this.field_145850_b, base.func_177967_a(f, 16), true);
                }
            }
            this.chunks.clear();
            this.func_70296_d();
            if (fail) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.craftfail, SoundCategory.BLOCKS, 0.5f, 1.0f);
            } else {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.wand, SoundCategory.BLOCKS, 0.5f, 1.0f);
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            block28: {
                if (this.ticks++ % 5 == 0 && this.activeBiome != null) {
                    ItemStack inv = this.inventory.getStackInSlot(0);
                    if (inv.func_190926_b() || !((IBiomeSelector)inv.getCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null)).getBiomeID().equals((Object)this.activeBiome)) {
                        this.activeBiome = null;
                        this.currentPos.func_181079_c(0, 0, 0);
                        this.blocksChecked = 0;
                        this.chunks.clear();
                        this.func_70296_d();
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.craftfail, SoundCategory.BLOCKS, 0.5f, 1.0f);
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                    } else {
                        for (EnumFacing facing : VALID_SIDES) {
                            IEssentiaTransport t;
                            TileEntity tileEntity;
                            Aspect aspect = this.getAspectForSide(facing);
                            if (this.essentia.getInt((Object)aspect) >= 30 || (tileEntity = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)facing)) == null || !(t = (IEssentiaTransport)tileEntity).canOutputTo(facing.func_176734_d()) || t.getEssentiaType(facing) != aspect || t.getEssentiaAmount(facing.func_176734_d()) <= 0 || t.getSuctionAmount(facing.func_176734_d()) >= this.getSuctionAmount(facing) || this.getSuctionAmount(facing) < t.getMinimumSuction()) continue;
                            this.essentia.addTo((Object)aspect, t.takeEssentia(aspect, 1, facing.func_176734_d()));
                        }
                        boolean skipSet = false;
                        while (true) {
                            skipSet = false;
                            if (!this.circle || (this.currentPos.func_177958_n() - this.field_174879_c.func_177958_n()) * (this.currentPos.func_177958_n() - this.field_174879_c.func_177958_n()) + (this.currentPos.func_177952_p() - this.field_174879_c.func_177952_p()) * (this.currentPos.func_177952_p() - this.field_174879_c.func_177952_p()) < this.radius * this.radius) {
                                if (this.activeBiome.equals((Object)IBiomeSelector.RESET) && !BiomeUtil.isNaturalBiomePresent(this.field_145850_b, (BlockPos)this.currentPos) || !this.activeBiome.equals((Object)IBiomeSelector.RESET) && !BiomeUtil.areBiomesSame(this.field_145850_b, (BlockPos)this.currentPos, (Biome)Biome.field_185377_q.func_82594_a((Object)this.activeBiome))) {
                                    if (!this.impetusPaid) {
                                        long cost = TAConfig.terraformerImpetusCost.getValue();
                                        ConsumeResult consume = this.consumer.consume(cost, true);
                                        if (consume.energyConsumed == cost) {
                                            consume = this.consumer.consume(cost, false);
                                            NodeHelper.syncAllImpetusTransactions(consume.paths.keySet());
                                            for (Map.Entry entry : consume.paths.entrySet()) {
                                                NodeHelper.damageEntitiesFromTransaction((Deque<IImpetusNode>)((Deque)entry.getKey()), (Long)entry.getValue());
                                            }
                                            this.impetusPaid = true;
                                            this.func_70296_d();
                                        }
                                    }
                                    if (!this.essentiaPaid) {
                                        Biome biome = this.activeBiome.equals((Object)IBiomeSelector.RESET) ? BiomeUtil.getNaturalBiome(this.field_145850_b, (BlockPos)this.currentPos, Biomes.field_76772_c) : (Biome)Biome.field_185377_q.func_82594_a((Object)this.activeBiome);
                                        Object2IntOpenHashMap neededAspects = null;
                                        try {
                                            neededAspects = (Object2IntOpenHashMap)BIOME_COSTS.get((Object)biome, () -> {
                                                Object2IntOpenHashMap map = new Object2IntOpenHashMap();
                                                map.put((Object)Aspect.EXCHANGE, 1);
                                                for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)biome)) {
                                                    Aspect aspect = BiomeUtil.getAspectForType(type, Aspect.EXCHANGE);
                                                    if (aspect == null) continue;
                                                    if (aspect == Aspect.ORDER || aspect == Aspect.ENTROPY) {
                                                        map.addTo((Object)Aspect.EXCHANGE, 1);
                                                        continue;
                                                    }
                                                    if (!aspect.isPrimal() && aspect != Aspect.EXCHANGE) continue;
                                                    map.addTo((Object)aspect, 1);
                                                }
                                                return map;
                                            });
                                        }
                                        catch (ExecutionException ex) {
                                            ThaumicAugmentation.getLogger().error("An exception was somehow thrown when it really should not have!");
                                            throw new RuntimeException(ex);
                                        }
                                        boolean enoughEssentia = true;
                                        for (Object2IntMap.Entry entry : neededAspects.object2IntEntrySet()) {
                                            if (this.essentia.getInt(entry.getKey()) >= entry.getIntValue()) continue;
                                            enoughEssentia = false;
                                            break;
                                        }
                                        if (enoughEssentia) {
                                            for (Object2IntMap.Entry entry : neededAspects.object2IntEntrySet()) {
                                                this.essentia.addTo(entry.getKey(), -entry.getIntValue());
                                            }
                                            this.essentiaPaid = true;
                                            this.func_70296_d();
                                        }
                                    }
                                    if (!this.visPaid && DoubleMath.fuzzyEquals((double)AuraHelper.drainVis((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)0.5f, (boolean)true), (double)0.5, (double)1.0E-5)) {
                                        AuraHelper.drainVis((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)0.5f, (boolean)false);
                                        this.visPaid = true;
                                        this.func_70296_d();
                                        TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.VIS_OPERATION, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0, 0.7, 0.875, 0.875, 0.85), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 64.0));
                                    }
                                } else {
                                    this.impetusPaid = true;
                                    this.essentiaPaid = true;
                                    this.visPaid = true;
                                    skipSet = true;
                                    this.func_70296_d();
                                }
                            } else {
                                this.impetusPaid = true;
                                this.essentiaPaid = true;
                                this.visPaid = true;
                                skipSet = true;
                                this.func_70296_d();
                            }
                            if (!this.impetusPaid || !this.essentiaPaid || !this.visPaid) break;
                            this.impetusPaid = false;
                            this.essentiaPaid = false;
                            this.visPaid = false;
                            if (!skipSet) {
                                if (this.activeBiome.equals((Object)IBiomeSelector.RESET)) {
                                    BiomeUtil.resetBiome(this.field_145850_b, (BlockPos)this.currentPos);
                                } else {
                                    BiomeUtil.setBiome(this.field_145850_b, (BlockPos)this.currentPos, (Biome)Biome.field_185377_q.func_82594_a((Object)this.activeBiome));
                                }
                                this.chunks.add(new ChunkPos((BlockPos)this.currentPos));
                                int y = this.field_145850_b.func_189649_b(this.currentPos.func_177958_n(), this.currentPos.func_177952_p());
                                NetworkRegistry.TargetPoint track = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.currentPos.func_177958_n(), (double)y, (double)this.currentPos.func_177952_p(), 64.0);
                                TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.SPARK, (double)this.currentPos.func_177958_n() + 0.5, y, (double)this.currentPos.func_177952_p() + 0.5, 8.0, Aspect.EXCHANGE.getColor()), track);
                                TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketTerraformerWork(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), track);
                                this.field_145850_b.func_184133_a(null, (BlockPos)this.currentPos, SoundsTC.zap, SoundCategory.BLOCKS, 0.15f, 1.0f);
                                break block28;
                            }
                            if (Math.abs(this.currentPos.func_177958_n() - this.field_174879_c.func_177958_n()) <= Math.abs(this.currentPos.func_177952_p() - this.field_174879_c.func_177952_p()) && (this.currentPos.func_177958_n() - this.field_174879_c.func_177958_n() != this.currentPos.func_177952_p() - this.field_174879_c.func_177952_p() || this.currentPos.func_177958_n() - this.field_174879_c.func_177958_n() >= 0)) {
                                this.currentPos.func_181079_c(this.currentPos.func_177958_n() + (this.currentPos.func_177952_p() - this.field_174879_c.func_177952_p() >= 0 ? 1 : -1), this.currentPos.func_177956_o(), this.currentPos.func_177952_p());
                            } else {
                                this.currentPos.func_181079_c(this.currentPos.func_177958_n(), this.currentPos.func_177956_o(), this.currentPos.func_177952_p() + (this.currentPos.func_177958_n() - this.field_174879_c.func_177958_n() >= 0 ? -1 : 1));
                            }
                            ++this.blocksChecked;
                            if (this.blocksChecked >= (this.radius * 2 - 1) * (this.radius * 2 - 1) + 1) {
                                this.endTerraforming(false);
                                break block28;
                            }
                            this.func_70296_d();
                        }
                        if (!this.visPaid) {
                            TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.VIS_OPERATION, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0, 0.1, 0.15, 0.15, 0.85), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 64.0));
                        }
                    }
                }
            }
            if (this.ticks % 20 == 0) {
                NodeHelper.validate(this.consumer, this.field_145850_b);
            }
        }
    }

    public boolean canInputFrom(EnumFacing facing) {
        return facing != EnumFacing.UP && this.activeBiome != null;
    }

    public boolean canOutputTo(EnumFacing facing) {
        return facing != EnumFacing.UP && this.activeBiome == null;
    }

    public int getEssentiaAmount(EnumFacing facing) {
        return facing == EnumFacing.UP ? 0 : this.essentia.getInt((Object)this.getAspectForSide(facing));
    }

    public Aspect getEssentiaType(EnumFacing facing) {
        return facing == EnumFacing.UP ? null : this.getAspectForSide(facing);
    }

    public int getMinimumSuction() {
        return 0;
    }

    public int getSuctionAmount(EnumFacing facing) {
        return facing == EnumFacing.UP ? 0 : 128;
    }

    public Aspect getSuctionType(EnumFacing facing) {
        return facing == EnumFacing.UP ? null : this.getAspectForSide(facing);
    }

    public boolean isConnectable(EnumFacing facing) {
        return facing != EnumFacing.UP;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public int addEssentia(Aspect aspect, int amount, EnumFacing facing) {
        if (aspect == this.getAspectForSide(facing)) {
            int taken = Math.min(amount, 30 - this.essentia.getInt((Object)aspect));
            this.essentia.addTo((Object)aspect, taken);
            return taken;
        }
        return 0;
    }

    public int takeEssentia(Aspect aspect, int amount, EnumFacing facing) {
        if (aspect == this.getAspectForSide(facing)) {
            int taken = Math.min(this.essentia.getInt((Object)aspect), amount);
            this.essentia.addTo((Object)aspect, -taken);
            return taken;
        }
        return 0;
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        if (this.field_145850_b != null) {
            this.consumer.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
        }
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.consumer.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
    }

    public void onLoad() {
        ThaumicAugmentation.proxy.registerRenderableImpetusNode(this.consumer);
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            NodeHelper.syncDestroyedImpetusNode(this.consumer);
        }
        this.consumer.destroy();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.consumer);
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.consumer.unload();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.consumer);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74782_a("node", (NBTBase)this.consumer.serializeNBT());
        compound.func_74768_a("radius", this.radius);
        compound.func_74757_a("circle", this.circle);
        if (this.activeBiome != null) {
            compound.func_74778_a("biome", this.activeBiome.toString());
            compound.func_74768_a("currentX", this.currentPos.func_177958_n());
            compound.func_74768_a("currentZ", this.currentPos.func_177952_p());
            compound.func_74768_a("checked", this.blocksChecked);
            compound.func_74757_a("impetusPaid", this.impetusPaid);
            compound.func_74757_a("essentiaPaid", this.essentiaPaid);
            compound.func_74757_a("visPaid", this.visPaid);
            NBTTagList cList = new NBTTagList();
            for (ChunkPos c : this.chunks) {
                cList.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{c.field_77276_a, c.field_77275_b}));
            }
            compound.func_74782_a("chunks", (NBTBase)cList);
        }
        int[] e = new int[]{this.essentia.getInt((Object)Aspect.EXCHANGE), this.essentia.getInt((Object)Aspect.AIR), this.essentia.getInt((Object)Aspect.EARTH), this.essentia.getInt((Object)Aspect.FIRE), this.essentia.getInt((Object)Aspect.WATER)};
        compound.func_74783_a("essentia", e);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        int[] e;
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.consumer.deserializeNBT(compound.func_74775_l("node"));
        this.radius = compound.func_74762_e("radius");
        this.circle = compound.func_74767_n("circle");
        if (compound.func_150297_b("biome", 8)) {
            this.activeBiome = new ResourceLocation(compound.func_74779_i("biome"));
            this.currentPos.func_181079_c(compound.func_74762_e("currentX"), this.field_174879_c.func_177956_o(), compound.func_74762_e("currentZ"));
            this.blocksChecked = compound.func_74762_e("checked");
            this.impetusPaid = compound.func_74767_n("impetusPaid");
            this.essentiaPaid = compound.func_74767_n("essentiaPaid");
            this.visPaid = compound.func_74767_n("visPaid");
            NBTTagList cList = compound.func_150295_c("chunks", 11);
            for (NBTBase tag : cList) {
                NBTTagIntArray arr;
                if (!(tag instanceof NBTTagIntArray) || (arr = (NBTTagIntArray)tag).func_150302_c().length != 2) continue;
                this.chunks.add(new ChunkPos(arr.func_150302_c()[0], arr.func_150302_c()[1]));
            }
        }
        if ((e = compound.func_74759_k("essentia")).length == 5) {
            this.essentia.put((Object)Aspect.EXCHANGE, e[0]);
            this.essentia.put((Object)Aspect.AIR, e[1]);
            this.essentia.put((Object)Aspect.EARTH, e[2]);
            this.essentia.put((Object)Aspect.FIRE, e[3]);
            this.essentia.put((Object)Aspect.WATER, e[4]);
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a("node", (NBTBase)this.consumer.serializeNBT());
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("radius", this.radius);
        tag.func_74757_a("circle", this.circle);
        if (this.activeBiome != null) {
            tag.func_74778_a("biome", this.activeBiome.toString());
        }
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        NodeHelper.tryConnectNewlyLoadedPeers(this.consumer, this.field_145850_b);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("biome", this.activeBiome != null ? this.activeBiome.toString() : "");
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("radius", this.radius);
        tag.func_74757_a("circle", this.circle);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        if (this.field_145850_b.field_72995_K) {
            String id = packet.func_148857_g().func_74779_i("biome");
            this.activeBiome = id.isEmpty() ? null : new ResourceLocation(id);
            this.inventory.deserializeNBT(packet.func_148857_g().func_74775_l("inventory"));
            this.radius = packet.func_148857_g().func_74762_e("radius");
            this.circle = packet.func_148857_g().func_74767_n("circle");
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c.func_177984_a());
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityImpetusNode.IMPETUS_NODE ? true : super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return (T)CapabilityImpetusNode.IMPETUS_NODE.cast((Object)this.consumer);
        }
        return (T)super.getCapability(capability, facing);
    }
}

