/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.world.feature;

import com.google.common.collect.ImmutableList;
import com.google.common.math.DoubleMath;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeProviderSingle;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.world.TADimensions;
import thecodex6824.thaumicaugmentation.common.entity.EntityDimensionalFracture;
import thecodex6824.thaumicaugmentation.common.util.WeightedRandom;
import thecodex6824.thaumicaugmentation.common.world.WorldDataCache;

public final class FractureUtils {
    private static final int WORLD_BORDER_MAX = 29999984;
    private static WeightedRandom<Integer> dimPicker;

    private FractureUtils() {
    }

    private static void reloadDimensionCache() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (String s : TAConfig.fractureDimList.getValue()) {
            String[] components = s.split("=", 2);
            if (components.length == 2) {
                int dim = 0;
                try {
                    dim = Integer.parseInt(components[0]);
                }
                catch (NumberFormatException ex) {
                    ThaumicAugmentation.getLogger().warn("Invalid FractureDimList dim entry, invalid dim: " + s);
                    continue;
                }
                int chance = 0;
                try {
                    chance = Integer.parseInt(components[1]);
                }
                catch (NumberFormatException ex) {
                    ThaumicAugmentation.getLogger().warn("Invalid FractureDimList chance entry, invalid chance: " + s);
                    continue;
                }
                if (dim != TADimensions.EMPTINESS.func_186068_a()) {
                    if (chance > 0) {
                        map.put(dim, chance);
                        continue;
                    }
                    if (chance >= 0) continue;
                    ThaumicAugmentation.getLogger().warn("Invalid FractureDimList chance entry, negative chance: " + s);
                    continue;
                }
                ThaumicAugmentation.getLogger().warn("Invalid FractureDimList dim entry, cannot specify Emptiness dim: " + s);
                continue;
            }
            ThaumicAugmentation.getLogger().warn("Invalid FractureDimList entry, wrong format: " + s);
        }
        dimPicker = new WeightedRandom(ImmutableList.copyOf(map.keySet()), (List<Integer>)ImmutableList.copyOf(map.values()));
    }

    public static void initDimensionCache() {
        if (!TAConfig.disableEmptiness.getValue().booleanValue()) {
            FractureUtils.reloadDimensionCache();
            TAConfig.addConfigListener(() -> FractureUtils.reloadDimensionCache());
        }
    }

    public static double movementRatio(World world) {
        return world.field_73011_w.getMovementFactor() / TAConfig.emptinessMoveFactor.getValue();
    }

    public static WorldDataCache.WorldData pickRandomDimension(Random rand, double maxFactor) {
        int dimID;
        if (dimPicker == null || dimPicker.isEmpty()) {
            return null;
        }
        WeightedRandom<Integer> currentPicker = dimPicker;
        do {
            WorldDataCache.WorldData dim;
            if ((dim = WorldDataCache.getData(dimID = currentPicker.get(rand).intValue())) == null || !(dim.getMovementFactor() <= maxFactor + 1.0E-5)) continue;
            return dim;
        } while (!(currentPicker = currentPicker.removeChoice(dimID)).isEmpty());
        return WorldDataCache.listAllDimensions().size() < 2 ? new WorldDataCache.WorldData(dimPicker.get(rand), rand.nextLong(), (BiomeProvider)new BiomeProviderSingle(Biomes.field_76772_c), maxFactor) : null;
    }

    public static boolean wouldLinkToDim(Random rand, int chunkX, int chunkZ, int targetDim) {
        return targetDim == FractureUtils.pickRandomDimension(rand, FractureUtils.calcMaxSafeFactor(TAConfig.emptinessMoveFactor.getValue(), chunkX, chunkZ)).getDimensionID();
    }

    public static boolean isDimAllowedForLinking(int dim) {
        if (dimPicker == null) {
            FractureUtils.initDimensionCache();
        }
        return dimPicker.hasChoice(dim);
    }

    public static double calcMaxSafeFactor(double moveFactor, int chunkX, int chunkZ) {
        return (double)Math.min(Math.abs(chunkX), Math.abs(chunkZ)) * moveFactor;
    }

    public static int scaleChunkCoord(int coord, double factor) {
        if (DoubleMath.isMathematicalInteger((double)factor)) {
            int integralFactor = (int)Math.floor(factor);
            return coord * integralFactor;
        }
        int integralFactor = (int)Math.round(1.0 / factor);
        return coord / integralFactor;
    }

    public static BlockPos scaleBlockPosFromEmptiness(BlockPos pos, double moveFactor, long seed) {
        double factor = TAConfig.emptinessMoveFactor.getValue() / moveFactor;
        int chunkX = FractureUtils.scaleChunkCoord(pos.func_177958_n() >> 4, factor);
        int chunkZ = FractureUtils.scaleChunkCoord(pos.func_177952_p() >> 4, factor);
        Random rand = new Random(seed);
        long xSeed = rand.nextLong() >> 3;
        long zSeed = rand.nextLong() >> 3;
        rand.setSeed(xSeed * (long)chunkX + zSeed * (long)chunkZ ^ seed);
        int offsetX = 8 + MathHelper.func_76136_a((Random)rand, (int)-2, (int)2);
        int offsetZ = 8 + MathHelper.func_76136_a((Random)rand, (int)-2, (int)2);
        return new BlockPos(chunkX * 16 + offsetX, 0, chunkZ * 16 + offsetZ);
    }

    public static BlockPos scaleBlockPosToEmptiness(BlockPos pos, double moveFactor, long seed) {
        double factor = moveFactor / TAConfig.emptinessMoveFactor.getValue();
        int chunkX = FractureUtils.scaleChunkCoord(pos.func_177958_n() >> 4, factor);
        int chunkZ = FractureUtils.scaleChunkCoord(pos.func_177952_p() >> 4, factor);
        Random rand = new Random(seed);
        long xSeed = rand.nextLong() >> 3;
        long zSeed = rand.nextLong() >> 3;
        rand.setSeed(xSeed * (long)chunkX + zSeed * (long)chunkZ ^ seed);
        if (rand.nextInt(TAConfig.fractureGenChance.getValue()) != 0) {
            ThaumicAugmentation.getLogger().warn("A fracture is generating, but its destination fracture will not? This is probably a bug.");
            ThaumicAugmentation.getLogger().debug("Dest dim: emptiness");
            ThaumicAugmentation.getLogger().debug("Src pos: " + pos);
        }
        int offsetX = 8 + MathHelper.func_76136_a((Random)rand, (int)-2, (int)2);
        int offsetZ = 8 + MathHelper.func_76136_a((Random)rand, (int)-2, (int)2);
        return new BlockPos(chunkX * 16 + offsetX, 0, chunkZ * 16 + offsetZ);
    }

    private static void doRedo(Random rand, EntityDimensionalFracture fracture) {
        if (fracture.func_130014_f_().field_73011_w.getDimension() == TADimensions.EMPTINESS.func_186068_a()) {
            BlockPos scaled;
            WorldDataCache.WorldData dim = FractureUtils.pickRandomDimension(rand, FractureUtils.calcMaxSafeFactor(TAConfig.emptinessMoveFactor.getValue(), fracture.field_70176_ah, fracture.field_70164_aj));
            if (dim != null && Math.abs((scaled = FractureUtils.scaleBlockPosFromEmptiness(fracture.func_180425_c(), dim.getMovementFactor(), dim.getWorldSeed())).func_177958_n()) < 29999984 && Math.abs(scaled.func_177952_p()) < 29999984) {
                fracture.setLinkLocated(false);
                fracture.setLinkedDimension(dim.getDimensionID());
                fracture.setLinkedPosition(scaled);
            }
        } else {
            BlockPos scaled;
            WorldDataCache.WorldData dim = WorldDataCache.getData(TADimensions.EMPTINESS.func_186068_a());
            if (dim != null && Math.abs((scaled = FractureUtils.scaleBlockPosToEmptiness(fracture.func_180425_c(), fracture.func_130014_f_().field_73011_w.getMovementFactor(), dim.getWorldSeed())).func_177958_n()) < 29999984 && Math.abs(scaled.func_177952_p()) < 29999984) {
                fracture.setLinkLocated(false);
                fracture.setLinkedDimension(dim.getDimensionID());
                fracture.setLinkedPosition(scaled);
            }
        }
    }

    public static void redoFractureLinkage(EntityDimensionalFracture fracture) {
        Random rand = new Random(fracture.func_130014_f_().func_72905_C());
        long xSeed = rand.nextLong() >> 3;
        long zSeed = rand.nextLong() >> 3;
        rand.setSeed(xSeed * (long)fracture.field_70176_ah + zSeed * (long)fracture.field_70164_aj ^ fracture.func_130014_f_().func_72905_C());
        if (fracture.func_130014_f_().field_73011_w.getDimension() == TADimensions.EMPTINESS.func_186068_a()) {
            if (rand.nextInt(TAConfig.fractureGenChance.getValue()) == 0) {
                if (Math.abs(fracture.field_70165_t) < 2.9999984E7 && Math.abs(fracture.field_70161_v) < 2.9999984E7) {
                    MathHelper.func_76136_a((Random)rand, (int)-2, (int)2);
                    MathHelper.func_76136_a((Random)rand, (int)-2, (int)2);
                    FractureUtils.doRedo(rand, fracture);
                }
            } else {
                ThaumicAugmentation.getLogger().warn("A fracture failed to generate when redoing its link. This is probably a bad thing.");
            }
        } else if (FractureUtils.isDimAllowedForLinking(fracture.func_130014_f_().field_73011_w.getDimension()) && FractureUtils.wouldLinkToDim(rand, fracture.field_70176_ah, fracture.field_70164_aj, fracture.func_130014_f_().field_73011_w.getDimension())) {
            MathHelper.func_76136_a((Random)rand, (int)-2, (int)2);
            MathHelper.func_76136_a((Random)rand, (int)-2, (int)2);
            FractureUtils.doRedo(rand, fracture);
        }
    }
}

