/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.thaumicjei.category;

import com.buuz135.thaumicjei.category.IHasResearch;
import com.buuz135.thaumicjei.drawable.AlphaDrawable;
import com.buuz135.thaumicjei.drawable.ItemStackDrawable;
import com.buuz135.thaumicjei.util.ResearchUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.items.resources.ItemCrystalEssence;

public class ArcaneWorkbenchCategory
implements IRecipeCategory<ArcaneWorkbenchWrapper> {
    public static final String UUID = "THAUMCRAFT_ARCANE_WORKBENCH";
    private IGuiHelper helper;

    public ArcaneWorkbenchCategory(IGuiHelper helper) {
        this.helper = helper;
    }

    public String getUid() {
        return UUID;
    }

    public String getTitle() {
        return new ItemStack(Block.func_149684_b((String)new ResourceLocation("thaumcraft", "arcane_workbench").toString())).func_82833_r();
    }

    public String getModName() {
        return "ThaumicJEI";
    }

    public IDrawable getBackground() {
        return new AlphaDrawable(new ResourceLocation("thaumcraft", "textures/gui/gui_researchbook_overlay.png"), 225, 31, 102, 102, 36, 0, 30, 30);
    }

    @Nullable
    public IDrawable getIcon() {
        return new ItemStackDrawable(new ItemStack(Block.func_149684_b((String)new ResourceLocation("thaumcraft", "arcane_workbench").toString())));
    }

    public void drawExtras(Minecraft minecraft) {
        minecraft.field_71446_o.func_110577_a(new ResourceLocation("thaumcraft", "textures/gui/gui_researchbook_overlay.png"));
        GL11.glEnable((int)3042);
        Gui.func_146110_a((int)65, (int)0, (float)40.0f, (float)6.0f, (int)32, (int)32, (float)512.0f, (float)512.0f);
        Gui.func_146110_a((int)12, (int)4, (float)135.0f, (float)152.0f, (int)23, (int)23, (float)512.0f, (float)512.0f);
        GL11.glDisable((int)3042);
    }

    public void setRecipe(IRecipeLayout recipeLayout, ArcaneWorkbenchWrapper recipeWrapper, IIngredients ingredients) {
        if (recipeWrapper.getRecipe() instanceof ShapelessArcaneRecipe) {
            recipeLayout.setShapeless();
        }
        recipeLayout.getItemStacks().init(0, false, 72, 7);
        int sizeX = 3;
        int sizeY = 3;
        int slot = 1;
        for (int y = 0; y < sizeY; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                if (ingredients.getInputs(VanillaTypes.ITEM).size() < slot) continue;
                recipeLayout.getItemStacks().init(slot, true, 12 + x * 30 + 30, 48 + y * 30);
                if (ingredients.getInputs(VanillaTypes.ITEM).get(slot - 1) != null) {
                    recipeLayout.getItemStacks().set(slot, (List)ingredients.getInputs(VanillaTypes.ITEM).get(slot - 1));
                }
                ++slot;
            }
        }
        int crystalAmount = 0;
        if (recipeWrapper.getRecipe().getCrystals() != null) {
            for (Aspect aspect : recipeWrapper.getRecipe().getCrystals().getAspectsSortedByAmount()) {
                ItemStack crystal = new ItemStack(ItemsTC.crystalEssence);
                ((ItemCrystalEssence)ItemsTC.crystalEssence).setAspects(crystal, new AspectList().add(aspect, 1));
                crystal.func_190920_e(recipeWrapper.getRecipe().getCrystals().getAmount(aspect));
                recipeLayout.getItemStacks().init(slot + crystalAmount, false, 141, 6 + 22 * crystalAmount);
                recipeLayout.getItemStacks().set(slot + crystalAmount, crystal);
                ++crystalAmount;
            }
        }
        recipeLayout.getItemStacks().set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Arrays.asList(new String[0]);
    }

    public static class ArcaneWorkbenchWrapper
    implements IHasResearch,
    IRecipeWrapper {
        private final IArcaneRecipe recipe;

        public ArcaneWorkbenchWrapper(IArcaneRecipe recipe) {
            this.recipe = recipe;
        }

        public void getIngredients(IIngredients ingredients) {
            ArrayList<List<ItemStack>> lists = new ArrayList<List<ItemStack>>();
            NonNullList input = new ArrayList();
            ItemStack output = null;
            if (this.recipe instanceof ShapelessArcaneRecipe) {
                input = this.recipe.func_192400_c();
                output = this.recipe.func_77571_b();
            } else if (this.recipe instanceof ShapedArcaneRecipe) {
                ShapedArcaneRecipe shapedArcaneRecipe = (ShapedArcaneRecipe)this.recipe;
                int sizeX = shapedArcaneRecipe.getRecipeWidth();
                int sizeY = shapedArcaneRecipe.getRecipeHeight();
                int slot = 0;
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 3; ++x) {
                        if (y < sizeY && x < sizeX) {
                            input.add(this.recipe.func_192400_c().get(slot));
                            ++slot;
                            continue;
                        }
                        input.add(Ingredient.field_193370_a);
                    }
                }
                output = this.recipe.func_77571_b();
            }
            for (Ingredient ingredient : input) {
                lists.add(Arrays.asList(ingredient.func_193365_a()));
            }
            ingredients.setInputLists(VanillaTypes.ITEM, lists);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)output);
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            minecraft.field_71466_p.func_78276_b(TextFormatting.DARK_GRAY + String.valueOf(this.recipe.getVis()), 50 - minecraft.field_71466_p.func_78256_a(String.valueOf(this.recipe.getVis())) / 2, 12, 0);
            if (!ThaumcraftCapabilities.knowsResearch((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (String[])this.getResearch())) {
                minecraft.func_175599_af().func_175042_a(new ItemStack(Blocks.field_180401_cv), 15, 8);
            }
        }

        @Nullable
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            if (mouseX > 34 && mouseX < 60 && mouseY > 4 && mouseY < 28) {
                return Arrays.asList("Vis Cost");
            }
            if (!ThaumcraftCapabilities.knowsResearch((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (String[])this.getResearch()) && mouseX > 10 && mouseX < 34 && mouseY > 4 && mouseY < 28) {
                return ResearchUtils.generateMissingResearchList(this.getResearch());
            }
            return null;
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }

        public IArcaneRecipe getRecipe() {
            return this.recipe;
        }

        @Override
        public String[] getResearch() {
            return new String[]{this.recipe.getResearch()};
        }
    }
}

