/*
 * Decompiled with CFR 0.152.
 */
package me.xfl03.thaumicwaila.provider;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.SpecialChars;
import me.xfl03.thaumicwaila.ThaumicWaila;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.apache.commons.lang3.text.WordUtils;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;

public class AspectContainerProvider
implements IWailaDataProvider {
    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te = accessor.getTileEntity();
        if (!(te instanceof IAspectContainer)) {
            return tooltip;
        }
        IAspectContainer container = (IAspectContainer)te;
        AspectList list = container.getAspects();
        if (list == null || list.size() <= 0) {
            return tooltip;
        }
        LinkedHashMap aspects = list.aspects;
        for (Aspect aspect : aspects.keySet()) {
            AspectContainerProvider.processAspect(tooltip, aspect.getTag(), (Integer)aspects.get(aspect));
        }
        return tooltip;
    }

    private static void processAspect(List<String> tooltip, String aspect, int amount) {
        String str = SpecialChars.getRenderString((String)"thaumicwaila.aspect", (String[])new String[]{aspect}) + String.format("%s" + SpecialChars.TAB + SpecialChars.ALIGNRIGHT + ChatFormatting.WHITE + "%d  ", WordUtils.capitalizeFully((String)aspect), amount);
        tooltip.add(str);
    }

    public static void register(IWailaRegistrar registrar) {
        try {
            Class.forName("thaumcraft.api.aspects.IAspectContainer");
        }
        catch (Exception ignored) {
            ThaumicWaila.LOG.warn("CLASS 'thaumcraft.api.aspects.IAspectContainer' not detected.");
            return;
        }
        AspectContainerProvider provider = new AspectContainerProvider();
        registrar.registerBodyProvider((IWailaDataProvider)provider, IAspectContainer.class);
        ThaumicWaila.LOG.info("AspectContainerProvider registered.");
    }
}

