/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.util.AEColor;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.core.AELog;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

class MemoryCardBakedModel
implements IBakedModel {
    private static final AEColor[] DEFAULT_COLOR_CODE = new AEColor[]{AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT};
    private final VertexFormat format;
    private final IBakedModel baseModel;
    private final TextureAtlasSprite texture;
    private final AEColor[] colorCode;
    private final Cache<CacheKey, MemoryCardBakedModel> modelCache;
    private final ImmutableList<BakedQuad> generalQuads;

    MemoryCardBakedModel(VertexFormat format, IBakedModel baseModel, TextureAtlasSprite texture) {
        this(format, baseModel, texture, DEFAULT_COLOR_CODE, MemoryCardBakedModel.createCache());
    }

    private MemoryCardBakedModel(VertexFormat format, IBakedModel baseModel, TextureAtlasSprite texture, AEColor[] hash, Cache<CacheKey, MemoryCardBakedModel> modelCache) {
        this.format = format;
        this.baseModel = baseModel;
        this.texture = texture;
        this.colorCode = hash;
        this.generalQuads = ImmutableList.copyOf(this.buildGeneralQuads());
        this.modelCache = modelCache;
    }

    private static Cache<CacheKey, MemoryCardBakedModel> createCache() {
        return CacheBuilder.newBuilder().maximumSize(100L).build();
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        List quads = this.baseModel.func_188616_a(state, side, rand);
        if (side != null) {
            return quads;
        }
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(quads.size() + this.generalQuads.size());
        result.addAll(quads);
        result.addAll((Collection<BakedQuad>)this.generalQuads);
        return result;
    }

    private List<BakedQuad> buildGeneralQuads() {
        CubeBuilder builder = new CubeBuilder(this.format);
        builder.setTexture(this.texture);
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 2; ++y) {
                AEColor color = this.colorCode[x + y * 4];
                builder.setColorRGB(color.mediumVariant);
                builder.addCube(7 + x, 8 + (1 - y), 7.5f, 7 + x + 1, 8 + (1 - y) + 1, 8.5f);
            }
        }
        return builder.getOutput();
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.baseModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.baseModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList(Collections.emptyList()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                try {
                    if (stack.func_77973_b() instanceof IMemoryCard) {
                        IMemoryCard memoryCard = (IMemoryCard)stack.func_77973_b();
                        AEColor[] colors = memoryCard.getColorCode(stack);
                        return (IBakedModel)MemoryCardBakedModel.this.modelCache.get((Object)new CacheKey(colors), () -> new MemoryCardBakedModel(MemoryCardBakedModel.this.format, MemoryCardBakedModel.this.baseModel, MemoryCardBakedModel.this.texture, colors, MemoryCardBakedModel.this.modelCache));
                    }
                }
                catch (ExecutionException e) {
                    AELog.error(e);
                }
                return MemoryCardBakedModel.this;
            }
        };
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
        if (this.baseModel instanceof IBakedModel) {
            IBakedModel pam = this.baseModel;
            Pair pair = pam.handlePerspective(type);
            return Pair.of((Object)this, (Object)((Matrix4f)pair.getValue()));
        }
        return Pair.of((Object)this, (Object)TRSRTransformation.identity().getMatrix());
    }

    private static class CacheKey {
        private final AEColor[] key;

        CacheKey(AEColor[] key) {
            this.key = key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode((Object[])this.key);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return Arrays.equals((Object[])this.key, (Object[])other.key);
        }
    }
}

