/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.storage.ITerminalHost;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerCraftingCPU;
import appeng.container.implementations.CraftingCPUStatus;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCraftingCPUsUpdate;
import appeng.util.Platform;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;

public class ContainerCraftingStatus
extends ContainerCraftingCPU {
    private ImmutableSet<ICraftingCPU> lastCpuSet = null;
    private List<CraftingCPUStatus> cpus = new ArrayList<CraftingCPUStatus>();
    private final WeakHashMap<ICraftingCPU, Integer> cpuSerialMap = new WeakHashMap();
    private int nextCpuSerial = 1;
    private int lastUpdate = 0;
    @GuiSync(value=5)
    public int selectedCpuSerial = -1;
    private static final Comparator<CraftingCPUStatus> CPU_COMPARATOR = Comparator.comparing(e -> e.getName() == null || e.getName().isEmpty()).thenComparing(e -> e.getName() != null ? e.getName() : "").thenComparingInt(CraftingCPUStatus::getSerial);

    public ContainerCraftingStatus(InventoryPlayer ip, ITerminalHost te) {
        super(ip, te);
    }

    @Override
    public void func_75142_b() {
        IGrid network = this.getNetwork();
        if (Platform.isServer() && network != null) {
            ICraftingGrid cc = (ICraftingGrid)network.getCache(ICraftingGrid.class);
            ImmutableSet<ICraftingCPU> cpuSet = cc.getCpus();
            ++this.lastUpdate;
            if (!cpuSet.equals(this.lastCpuSet) || this.lastUpdate > 20) {
                this.lastUpdate = 0;
                this.lastCpuSet = cpuSet;
                this.updateCpuList();
                this.sendCPUs();
            }
        }
        if (this.selectedCpuSerial != -1 && this.cpus.stream().noneMatch(c -> c.getSerial() == this.selectedCpuSerial)) {
            this.selectCPU(-1);
        }
        if (this.selectedCpuSerial == -1) {
            for (CraftingCPUStatus cpu : this.cpus) {
                if (cpu.getRemainingItems() <= 0L) continue;
                this.selectCPU(cpu.getSerial());
                break;
            }
            if (this.selectedCpuSerial == -1 && !this.cpus.isEmpty()) {
                this.selectCPU(this.cpus.get(0).getSerial());
            }
        }
        super.func_75142_b();
    }

    private void updateCpuList() {
        this.cpus.clear();
        for (ICraftingCPU cpu : this.lastCpuSet) {
            int serial = this.getOrAssignCpuSerial(cpu);
            this.cpus.add(new CraftingCPUStatus(cpu, serial));
        }
        this.cpus.sort(CPU_COMPARATOR);
    }

    private int getOrAssignCpuSerial(ICraftingCPU cpu) {
        return this.cpuSerialMap.computeIfAbsent(cpu, unused -> this.nextCpuSerial++);
    }

    private boolean cpuMatches(ICraftingCPU c) {
        return c.isBusy();
    }

    private void sendCPUs() {
        for (Object player : this.field_75149_d) {
            if (!(player instanceof EntityPlayerMP)) continue;
            try {
                NetworkHandler.instance.sendTo(new PacketCraftingCPUsUpdate(this.cpus), (EntityPlayerMP)player);
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        }
    }

    public void selectCPU(int serial) {
        if (Platform.isServer()) {
            if (serial < -1) {
                serial = -1;
            }
            int searchedSerial = serial;
            if (serial > -1 && this.cpus.stream().noneMatch(c -> c.getSerial() == searchedSerial)) {
                serial = -1;
            }
            ICraftingCPU newSelectedCpu = null;
            if (serial != -1) {
                for (ICraftingCPU cpu : this.lastCpuSet) {
                    if (this.cpuSerialMap.getOrDefault(cpu, -1) != serial) continue;
                    newSelectedCpu = cpu;
                    break;
                }
            }
            if (newSelectedCpu != this.getMonitor()) {
                this.selectedCpuSerial = serial;
                this.setCPU(newSelectedCpu);
            }
        }
    }

    public List<CraftingCPUStatus> getCPUs() {
        return Collections.unmodifiableList(this.cpus);
    }

    public void postCPUUpdate(CraftingCPUStatus[] cpus) {
        this.cpus = Arrays.asList(cpus);
    }
}

