/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.api;

import appeng.api.AEApi;
import appeng.api.definitions.ITileDefinition;
import appeng.api.parts.CableRenderMode;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHelper;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import appeng.core.AppEng;
import appeng.parts.PartPlacement;
import appeng.util.Platform;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class ApiPart
implements IPartHelper {
    @Override
    public EnumActionResult placeBus(ItemStack is, BlockPos pos, EnumFacing side, EntityPlayer player, EnumHand hand, World w) {
        return PartPlacement.place(is, pos, side, player, hand, w);
    }

    @Override
    public CableRenderMode getCableRenderMode() {
        return AppEng.proxy.getRenderMode();
    }

    @Override
    @Nullable
    public IPart getPart(World w, BlockPos pos, AEPartLocation side) {
        TileEntity tile = w.func_175625_s(pos);
        if (tile instanceof IPartHost) {
            IPartHost partHost = (IPartHost)tile;
            return partHost.getPart(side);
        }
        return null;
    }

    @Override
    @Nullable
    public IPartHost getPartHost(World w, BlockPos pos) {
        TileEntity tile = w.func_175625_s(pos);
        if (tile instanceof IPartHost) {
            IPartHost partHost = (IPartHost)tile;
            return partHost;
        }
        return null;
    }

    @Override
    @Nullable
    public IPartHost getOrPlacePartHost(World w, BlockPos pos, boolean force, @Nullable EntityPlayer p) {
        IPartHost host;
        TileEntity tile = w.func_175625_s(pos);
        if (tile instanceof IPartHost) {
            IPartHost partHost = (IPartHost)tile;
            return partHost;
        }
        if (!force && !this.canPlacePartHost(w, pos, p)) {
            return null;
        }
        ITileDefinition multiPart = AEApi.instance().definitions().blocks().multiPart();
        if (!multiPart.isEnabled()) {
            return null;
        }
        Block blk = multiPart.maybeBlock().orElse(null);
        if (blk == null) {
            return null;
        }
        IBlockState state = blk.func_176223_P();
        w.func_180501_a(pos, state, 3);
        TileEntity tileEntity = w.func_175625_s(pos);
        return tileEntity instanceof IPartHost ? (host = (IPartHost)tileEntity) : null;
    }

    @Override
    public boolean canPlacePartHost(World w, BlockPos pos, @Nullable EntityPlayer p) {
        if (p != null && !Platform.hasPermissions(w, pos, p)) {
            return false;
        }
        Block blk = w.func_180495_p(pos).func_177230_c();
        return blk == null || blk.func_176200_f((IBlockAccess)w, pos);
    }
}

