/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.security.IActionHost;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.Future;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketCraftRequest
extends AppEngPacket {
    private final long amount;
    private final boolean heldShift;

    public PacketCraftRequest(ByteBuf stream) {
        this.heldShift = stream.readBoolean();
        this.amount = stream.readLong();
    }

    public PacketCraftRequest(int craftAmt, boolean shift) {
        this.amount = craftAmt;
        this.heldShift = shift;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeBoolean(shift);
        data.writeLong(this.amount);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        ContainerCraftAmount cca;
        Object target;
        if (player.field_71070_bA instanceof ContainerCraftAmount && (target = (cca = (ContainerCraftAmount)player.field_71070_bA).getTarget()) instanceof IActionHost) {
            IActionHost ah = (IActionHost)target;
            IGridNode gn = ah.getActionableNode();
            if (gn == null) {
                return;
            }
            IGrid g = gn.getGrid();
            if (g == null || cca.getItemToCraft() == null) {
                return;
            }
            cca.getItemToCraft().setStackSize(this.amount);
            Future<ICraftingJob> futureJob = null;
            try {
                ICraftingGrid cg = (ICraftingGrid)g.getCache(ICraftingGrid.class);
                futureJob = cg.beginCraftingJob(cca.getWorld(), cca.getGrid(), cca.getActionSrc(), cca.getItemToCraft(), null);
                ContainerOpenContext context = cca.getOpenContext();
                if (context != null) {
                    TileEntity te = context.getTile();
                    if (te != null) {
                        Platform.openGUI(player, te, cca.getOpenContext().getSide(), GuiBridge.GUI_CRAFTING_CONFIRM);
                    } else if (ah instanceof IInventorySlotAware) {
                        IInventorySlotAware i = (IInventorySlotAware)((Object)ah);
                        Platform.openGUI(player, i.getInventorySlot(), GuiBridge.GUI_CRAFTING_CONFIRM, i.isBaubleSlot());
                    }
                    if (player.field_71070_bA instanceof ContainerCraftConfirm) {
                        ContainerCraftConfirm ccc = (ContainerCraftConfirm)player.field_71070_bA;
                        ccc.setAutoStart(this.heldShift);
                        ccc.setJob(futureJob);
                        cca.func_75142_b();
                    }
                }
            }
            catch (Throwable e) {
                if (futureJob != null) {
                    futureJob.cancel(true);
                }
                AELog.debug(e);
            }
        }
    }
}

