/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.transformer;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketColorApplicatorSelectColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class PickBlockPatch
extends ClassVisitor {
    public PickBlockPatch(ClassVisitor cv) {
        super(327680, cv);
    }

    public static boolean testColorApplicatorPickBlock(RayTraceResult result, EntityPlayer player, World world) {
        if (player == null || player.field_70170_p == null || result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
            return false;
        }
        IItemDefinition applicator = AEApi.instance().definitions().items().colorApplicator();
        if (!applicator.isSameAs(player.func_184614_ca()) && !applicator.isSameAs(player.func_184592_cb())) {
            return false;
        }
        TileEntity tile = player.field_70170_p.func_175625_s(result.func_178782_a());
        if (tile instanceof IColorableTile) {
            IColorableTile colorableTile = (IColorableTile)tile;
            NetworkHandler.instance().sendToServer(new PacketColorApplicatorSelectColor(colorableTile.getColor()));
            return true;
        }
        return false;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ("onPickBlock".equals(name)) {
            return new OnPickBlockVisitor(mv);
        }
        return mv;
    }

    private static class OnPickBlockVisitor
    extends MethodVisitor
    implements Opcodes {
        public OnPickBlockVisitor(MethodVisitor mv) {
            super(327680, mv);
        }

        public void visitCode() {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitVarInsn(25, 2);
            this.mv.visitMethodInsn(184, "appeng/core/transformer/PickBlockPatch", "testColorApplicatorPickBlock", "(Lnet/minecraft/util/math/RayTraceResult;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;)Z", false);
            this.mv.visitInsn(89);
            Label exitLabel = new Label();
            this.mv.visitJumpInsn(153, exitLabel);
            this.mv.visitInsn(172);
            this.mv.visitLabel(exitLabel);
        }
    }
}

