/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.AEApi;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEPartLocation;
import appeng.core.AEConfig;
import appeng.facade.FacadePart;
import appeng.facade.IFacadeItem;
import appeng.items.parts.ItemFacade;
import appeng.parts.BusCollisionHelper;
import appeng.parts.PartPlacement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class RenderBlockOutlineHook {
    @SubscribeEvent
    public static void onDrawHighlightEvent(DrawBlockHighlightEvent event) {
        if (event.getTarget() == null) {
            return;
        }
        if (event.getTarget().func_178782_a() == null) {
            return;
        }
        if (event.getTarget().field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        RayTraceResult hitResult = event.getTarget();
        if (player.field_70170_p.func_180495_p(hitResult.func_178782_a()).func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        if (RenderBlockOutlineHook.replaceBlockOutline(player, stack, hitResult, event.getPartialTicks())) {
            event.setCanceled(true);
        }
    }

    private static boolean replaceBlockOutline(EntityPlayer player, ItemStack stack, RayTraceResult hitResult, float partialTicks) {
        IPartHost host;
        BlockPos pos = hitResult.func_178782_a();
        if (AEConfig.instance().showPlacementPreview()) {
            RenderBlockOutlineHook.renderPartPlacementPreview(player, hitResult, stack, partialTicks);
        }
        if ((host = AEApi.instance().partHelper().getPartHost(player.field_70170_p, pos)) != null) {
            if (AEConfig.instance().showPlacementPreview()) {
                RenderBlockOutlineHook.renderFacadePlacementPreview(host, player, hitResult, stack, partialTicks);
            }
            SelectedPart selectedPart = host.selectPartGlobal(hitResult.field_72307_f);
            if (selectedPart.facade != null) {
                RenderBlockOutlineHook.renderFacade(selectedPart.facade, host, pos, selectedPart.side.getFacing(), player, partialTicks, false, false);
                return true;
            }
            if (selectedPart.part != null) {
                RenderBlockOutlineHook.renderPart(selectedPart.part, pos, selectedPart.side.getFacing(), player, partialTicks, false, false);
                return true;
            }
        }
        return false;
    }

    private static void renderPartPlacementPreview(EntityPlayer player, RayTraceResult hitResult, ItemStack stack, float partialTicks) {
        Item item = stack.func_77973_b();
        if (!(item instanceof IPartItem)) {
            return;
        }
        IPartItem partItem = (IPartItem)item;
        PartPlacement.Placement placement = PartPlacement.getPartPlacement(player, player.field_70170_p, stack, hitResult.func_178782_a(), hitResult.field_178784_b);
        if (placement == null) {
            return;
        }
        if (!player.field_70170_p.func_175723_af().func_177746_a(placement.pos())) {
            return;
        }
        Object part = partItem.createPartFromItemStack(stack);
        if (part == null) {
            return;
        }
        RenderBlockOutlineHook.renderPart(part, placement.pos(), placement.side(), player, partialTicks, true, true);
        RenderBlockOutlineHook.renderPart(part, placement.pos(), placement.side(), player, partialTicks, true, false);
    }

    private static void renderFacadePlacementPreview(@Nonnull IPartHost host, EntityPlayer player, RayTraceResult hitResult, ItemStack stack, float partialTicks) {
        Item item = stack.func_77973_b();
        if (!(item instanceof IFacadeItem)) {
            return;
        }
        IFacadeItem facadeItem = (IFacadeItem)item;
        PartPlacement.Placement placement = PartPlacement.getPartPlacement(player, player.field_70170_p, stack, hitResult.func_178782_a(), hitResult.field_178784_b);
        if (placement == null) {
            return;
        }
        FacadePart part = facadeItem.createPartFromItemStack(stack, AEPartLocation.fromFacing(placement.side()));
        if (part == null) {
            return;
        }
        if (!ItemFacade.canPlaceFacade(host, part)) {
            return;
        }
        RenderBlockOutlineHook.renderFacade(part, host, placement.pos(), placement.side(), player, partialTicks, true, true);
        RenderBlockOutlineHook.renderFacade(part, host, placement.pos(), placement.side(), player, partialTicks, true, false);
    }

    private static void renderPart(IPart part, BlockPos pos, EnumFacing side, EntityPlayer player, float partialTicks, boolean preview, boolean insideBlock) {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        BusCollisionHelper helper = new BusCollisionHelper(boxes, AEPartLocation.fromFacing(side), (Entity)player, true);
        part.getBoxes(helper);
        RenderBlockOutlineHook.offsetBoxes(boxes, pos, player, partialTicks);
        RenderBlockOutlineHook.renderBoxes(boxes, preview, insideBlock);
    }

    private static void renderFacade(IFacadePart facade, IPartHost host, BlockPos pos, EnumFacing side, EntityPlayer player, float partialTicks, boolean preview, boolean insideBlock) {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        BusCollisionHelper helper = new BusCollisionHelper(boxes, AEPartLocation.fromFacing(side), (Entity)player, true);
        facade.getBoxes(helper, (Entity)player);
        if (host.getPart(side) == null && preview) {
            RenderBlockOutlineHook.addAnchorBox(helper);
        }
        RenderBlockOutlineHook.offsetBoxes(boxes, pos, player, partialTicks);
        RenderBlockOutlineHook.renderBoxes(boxes, preview, insideBlock);
    }

    private static void renderBoxes(List<AxisAlignedBB> boxes, boolean preview, boolean insideBlock) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        if (insideBlock) {
            GL11.glDisable((int)2929);
        }
        for (AxisAlignedBB box : boxes) {
            RenderGlobal.func_189697_a((AxisAlignedBB)box, (float)(preview ? 1.0f : 0.0f), (float)(preview ? 1.0f : 0.0f), (float)(preview ? 1.0f : 0.0f), (float)(insideBlock ? 0.2f : (preview ? 0.6f : 0.4f)));
        }
        if (insideBlock) {
            GL11.glEnable((int)2929);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    private static void offsetBoxes(List<AxisAlignedBB> boxes, BlockPos pos, EntityPlayer player, float partialTicks) {
        double dX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        boxes.replaceAll(box -> box.func_72317_d((double)pos.func_177958_n() - dX, (double)pos.func_177956_o() - dY, (double)pos.func_177952_p() - dZ).func_186662_g(0.002));
    }

    private static void addAnchorBox(IPartCollisionHelper helper) {
        IPartItem anchorPartItem;
        Object anchorPart;
        Item item;
        ItemStack anchorStack = AEApi.instance().definitions().parts().cableAnchor().maybeStack(1).orElse(null);
        if (anchorStack != null && (item = anchorStack.func_77973_b()) instanceof IPartItem && (anchorPart = (anchorPartItem = (IPartItem)item).createPartFromItemStack(anchorStack)) != null) {
            anchorPart.getBoxes(helper);
        }
    }
}

