/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.Actionable;
import appeng.api.exceptions.AppEngException;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.me.storage.AbstractCellInventory;
import appeng.util.item.AEStack;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BasicCellInventory<T extends IAEStack<T>>
extends AbstractCellInventory<T> {
    private final IStorageChannel<T> channel;

    private BasicCellInventory(IStorageCell<T> cellType, ItemStack o, ISaveProvider container) {
        super(cellType, o, container);
        this.channel = cellType.getChannel();
    }

    public static <T extends IAEStack<T>> ICellInventory<T> createInventory(ItemStack o, ISaveProvider container) {
        try {
            if (o == null) {
                throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
            }
            Item type = o.func_77973_b();
            if (!(type instanceof IStorageCell)) {
                throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
            }
            IStorageCell cellType = (IStorageCell)type;
            if (!cellType.isStorageCell(o)) {
                throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
            }
            return new BasicCellInventory<T>(cellType, o, container);
        }
        catch (AppEngException e) {
            AELog.error(e);
            return null;
        }
    }

    public static <T extends AEStack<T>> boolean isCellOfType(ItemStack input, IStorageChannel<?> channel) {
        IStorageCell<?> type = BasicCellInventory.getStorageCell(input);
        return type != null && type.getChannel() == channel;
    }

    public static boolean isCell(ItemStack input) {
        return BasicCellInventory.getStorageCell(input) != null;
    }

    private boolean isStorageCell(T input) {
        if (input instanceof IAEItemStack) {
            IAEItemStack stack = (IAEItemStack)input;
            IStorageCell<?> type = BasicCellInventory.getStorageCell(stack.getDefinition());
            return type != null && !type.storableInStorageCell();
        }
        return false;
    }

    private static IStorageCell<?> getStorageCell(ItemStack input) {
        Item type;
        if (input != null && (type = input.func_77973_b()) instanceof IStorageCell) {
            return (IStorageCell)type;
        }
        return null;
    }

    private static boolean isCellEmpty(ICellInventory inv) {
        if (inv != null) {
            return inv.getAvailableItems(inv.getChannel().createList()).isEmpty();
        }
        return true;
    }

    @Override
    public T injectItems(T input, Actionable mode, IActionSource src) {
        long remainingItemCount;
        ICellInventory<T> meInventory;
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        if (this.cellType.isBlackListed(this.getItemStack(), input)) {
            return input;
        }
        if (this.isStorageCell(input) && !BasicCellInventory.isCellEmpty(meInventory = BasicCellInventory.createInventory(((IAEItemStack)input).createItemStack(), null))) {
            return input;
        }
        T l = this.getCellItems().findPrecise(input);
        if (l != null) {
            long remainingItemCount2 = this.getRemainingItemCount();
            if (remainingItemCount2 <= 0L) {
                return input;
            }
            if (input.getStackSize() > remainingItemCount2) {
                Object r = input.copy();
                r.setStackSize(r.getStackSize() - remainingItemCount2);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() + remainingItemCount2);
                    this.saveChanges();
                }
                return r;
            }
            if (mode == Actionable.MODULATE) {
                l.setStackSize(l.getStackSize() + input.getStackSize());
                this.saveChanges();
            }
            return null;
        }
        if (this.canHoldNewItem() && (remainingItemCount = this.getRemainingItemCount() - (long)this.getBytesPerType() * (long)this.itemsPerByte) > 0L) {
            if (input.getStackSize() > remainingItemCount) {
                Object toReturn = input.copy();
                toReturn.setStackSize(input.getStackSize() - remainingItemCount);
                if (mode == Actionable.MODULATE) {
                    Object toWrite = input.copy();
                    toWrite.setStackSize(remainingItemCount);
                    this.cellItems.add(toWrite);
                    this.saveChanges();
                }
                return toReturn;
            }
            if (mode == Actionable.MODULATE) {
                this.cellItems.add(input);
                this.saveChanges();
            }
            return null;
        }
        return input;
    }

    @Override
    public T extractItems(T request, Actionable mode, IActionSource src) {
        if (request == null) {
            return null;
        }
        long size = Math.min(Integer.MAX_VALUE, request.getStackSize());
        IAEStack Results = null;
        T l = this.getCellItems().findPrecise(request);
        if (l != null) {
            Results = (IAEStack)l.copy();
            if (l.getStackSize() <= size) {
                Results.setStackSize(l.getStackSize());
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(0L);
                    this.saveChanges();
                }
            } else {
                Results.setStackSize(size);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() - size);
                    this.saveChanges();
                }
            }
        }
        return (T)Results;
    }

    @Override
    public IStorageChannel<T> getChannel() {
        return this.channel;
    }

    @Override
    protected boolean loadCellItem(NBTTagCompound compoundTag, long stackSize) {
        T t;
        try {
            t = this.getChannel().createFromNBT(compoundTag);
            if (t == null) {
                AELog.warn("Removing item " + compoundTag + " from storage cell because the associated item type couldn't be found.", new Object[0]);
                return false;
            }
        }
        catch (Throwable ex) {
            if (AEConfig.instance().isRemoveCrashingItemsOnLoad()) {
                AELog.warn(ex, "Removing item " + compoundTag + " from storage cell because loading the ItemStack crashed.");
                return false;
            }
            throw ex;
        }
        t.setStackSize(stackSize);
        t.setCraftable(false);
        if (stackSize > 0L) {
            this.cellItems.add(t);
        }
        return true;
    }
}

