/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.block.BlockTFTowerDevice;
import twilightforest.block.TFBlocks;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.client.ModelUtils;
import twilightforest.enums.TowerDeviceVariant;
import twilightforest.enums.TowerTranslucentVariant;
import twilightforest.item.TFItems;

public class BlockTFTowerTranslucent
extends Block
implements ModelRegisterCallback {
    public static final IProperty<TowerTranslucentVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", TowerTranslucentVariant.class);
    private static final AxisAlignedBB REAPPEARING_BB = new AxisAlignedBB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);

    public BlockTFTowerTranslucent() {
        super(Material.field_151592_s);
        this.func_149711_c(50.0f);
        this.func_149752_b(2000.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(TFItems.creativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)TowerTranslucentVariant.REAPPEARING_INACTIVE)));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public int func_176201_c(IBlockState state) {
        return ((TowerTranslucentVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)TowerTranslucentVariant.values()[meta]));
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149738_a(World world) {
        return 15;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return Items.field_190931_a;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    @Deprecated
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch ((TowerTranslucentVariant)((Object)state.func_177229_b(VARIANT))) {
            case REAPPEARING_INACTIVE: 
            case REAPPEARING_ACTIVE: {
                return field_185506_k;
            }
        }
        return super.func_180646_a(state, world, pos);
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch ((TowerTranslucentVariant)((Object)state.func_177229_b(VARIANT))) {
            case REAPPEARING_INACTIVE: 
            case REAPPEARING_ACTIVE: {
                return REAPPEARING_BB;
            }
        }
        return field_185505_j;
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        switch ((TowerTranslucentVariant)((Object)state.func_177229_b(VARIANT))) {
            case REAPPEARING_INACTIVE: 
            case REAPPEARING_ACTIVE: {
                return BlockFaceShape.UNDEFINED;
            }
        }
        return super.func_193383_a(worldIn, state, pos, face);
    }

    @Deprecated
    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        switch ((TowerTranslucentVariant)((Object)state.func_177229_b(VARIANT))) {
            case REVERTER_REPLACEMENT: 
            case REACTOR_DEBRIS: {
                return 0.3f;
            }
        }
        return super.func_176195_g(state, world, pos);
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        switch ((TowerTranslucentVariant)((Object)world.func_180495_p(pos).func_177229_b(VARIANT))) {
            case REAPPEARING_INACTIVE: 
            case REAPPEARING_ACTIVE: {
                return true;
            }
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (world.field_72995_K) {
            return;
        }
        TowerTranslucentVariant variant = (TowerTranslucentVariant)((Object)state.func_177229_b(VARIANT));
        if (variant == TowerTranslucentVariant.BUILT_ACTIVE) {
            world.func_175698_g(pos);
            world.func_175722_b(pos, (Block)this, false);
            world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.3f, 0.5f);
            for (EnumFacing e : EnumFacing.field_82609_l) {
                BlockTFTowerDevice.checkAndActivateVanishBlock(world, pos.func_177972_a(e));
            }
        } else if (variant == TowerTranslucentVariant.REAPPEARING_ACTIVE) {
            world.func_175656_a(pos, TFBlocks.tower_device.func_176223_P().func_177226_a(BlockTFTowerDevice.VARIANT, (Comparable)((Object)TowerDeviceVariant.REAPPEARING_INACTIVE)));
            world.func_175722_b(pos, (Block)this, false);
            world.func_184133_a(null, pos, SoundEvents.field_187883_gR, SoundCategory.BLOCKS, 0.3f, 0.5f);
        } else if (variant == TowerTranslucentVariant.REAPPEARING_INACTIVE) {
            BlockTFTowerDevice.changeToActiveVanishBlock(world, pos, TowerTranslucentVariant.REAPPEARING_ACTIVE);
        }
    }

    public void func_149666_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelUtils.registerToStateSingleVariant(this, VARIANT);
    }
}

