/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraftforge.common.util.BlockSnapshot;
import twilightforest.TFFeature;
import twilightforest.loot.TFTreasure;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.StructureTFStrongholdStones;
import twilightforest.util.StructureBoundingBoxUtils;

@Deprecated
public abstract class StructureTFComponentOld
extends StructureTFComponent {
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final StructureTFStrongholdStones strongholdStones = new StructureTFStrongholdStones();

    public StructureTFComponentOld() {
    }

    public StructureTFComponentOld(TFFeature feature, int i) {
        super(i);
        this.feature = feature;
    }

    @Override
    public TFFeature getFeatureType() {
        return this.feature;
    }

    public void func_186164_a(@Nullable EnumFacing facing) {
        this.field_74885_f = facing;
        this.field_186168_b = Mirror.NONE;
        if (facing == null) {
            this.field_186169_c = Rotation.NONE;
        } else {
            switch (facing) {
                case SOUTH: {
                    this.field_186169_c = Rotation.CLOCKWISE_180;
                    break;
                }
                case WEST: {
                    this.field_186169_c = Rotation.COUNTERCLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.field_186169_c = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.field_186169_c = Rotation.NONE;
                }
            }
        }
    }

    public static StructureBoundingBox getComponentToAddBoundingBox(int x, int y, int z, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, @Nullable EnumFacing dir) {
        switch (dir) {
            default: {
                return new StructureBoundingBox(x + minX, y + minY, z + minZ, x + maxX + minX, y + maxY + minY, z + maxZ + minZ);
            }
            case SOUTH: {
                return new StructureBoundingBox(x + minX, y + minY, z + minZ, x + maxX + minX, y + maxY + minY, z + maxZ + minZ);
            }
            case WEST: {
                return new StructureBoundingBox(x - maxZ + minZ, y + minY, z + minX, x + minZ, y + maxY + minY, z + maxX + minX);
            }
            case NORTH: {
                return new StructureBoundingBox(x - maxX - minX, y + minY, z - maxZ - minZ, x - minX, y + maxY + minY, z - minZ);
            }
            case EAST: 
        }
        return new StructureBoundingBox(x + minZ, y + minY, z - maxX, x + maxZ + minZ, y + maxY + minY, z + minX);
    }

    public static StructureBoundingBox getComponentToAddBoundingBox2(int x, int y, int z, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, EnumFacing dir) {
        switch (dir) {
            default: {
                return new StructureBoundingBox(x + minX, y + minY, z + minZ, x + maxX + minX, y + maxY + minY, z + maxZ + minZ);
            }
            case SOUTH: {
                return new StructureBoundingBox(x + minX, y + minY, z + minZ, x + maxX + minX, y + maxY + minY, z + maxZ + minZ);
            }
            case WEST: {
                return new StructureBoundingBox(x - maxZ - minZ, y + minY, z + minX, x - minZ, y + maxY + minY, z + maxX + minX);
            }
            case NORTH: {
                return new StructureBoundingBox(x - maxX - minX, y + minY, z - maxZ - minZ, x - minX, y + maxY + minY, z - minZ);
            }
            case EAST: 
        }
        return new StructureBoundingBox(x + minZ, y + minY, z - maxX, x + maxZ + minZ, y + maxY + minY, z - minX);
    }

    protected TileEntityMobSpawner setSpawner(World world, int x, int y, int z, StructureBoundingBox sbb, ResourceLocation monsterID) {
        int dz;
        int dy;
        TileEntityMobSpawner tileEntitySpawner = null;
        int dx = this.func_74865_a(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.func_74862_a(y), dz = this.func_74873_b(x, z));
        if (sbb.func_175898_b((Vec3i)pos) && world.func_180495_p(pos).func_177230_c() != Blocks.field_150474_ac) {
            world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
            tileEntitySpawner = (TileEntityMobSpawner)world.func_175625_s(pos);
            if (tileEntitySpawner != null) {
                tileEntitySpawner.func_145881_a().func_190894_a(monsterID);
            }
        }
        return tileEntitySpawner;
    }

    protected void surroundBlockCardinal(World world, IBlockState block, int x, int y, int z, StructureBoundingBox sbb) {
        this.func_175811_a(world, block, x + 0, y, z - 1, sbb);
        this.func_175811_a(world, block, x + 0, y, z + 1, sbb);
        this.func_175811_a(world, block, x - 1, y, z + 0, sbb);
        this.func_175811_a(world, block, x + 1, y, z + 0, sbb);
    }

    protected void surroundBlockCardinalRotated(World world, IBlockState block, int x, int y, int z, StructureBoundingBox sbb) {
        this.func_175811_a(world, block.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), x + 0, y, z - 1, sbb);
        this.func_175811_a(world, block.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH), x + 0, y, z + 1, sbb);
        this.func_175811_a(world, block.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), x - 1, y, z + 0, sbb);
        this.func_175811_a(world, block.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST), x + 1, y, z + 0, sbb);
    }

    protected void surroundBlockCorners(World world, IBlockState block, int x, int y, int z, StructureBoundingBox sbb) {
        this.func_175811_a(world, block, x - 1, y, z - 1, sbb);
        this.func_175811_a(world, block, x - 1, y, z + 1, sbb);
        this.func_175811_a(world, block, x + 1, y, z - 1, sbb);
        this.func_175811_a(world, block, x + 1, y, z + 1, sbb);
    }

    protected TileEntityMobSpawner setSpawnerRotated(World world, int x, int y, int z, Rotation rotation, ResourceLocation monsterID, StructureBoundingBox sbb) {
        EnumFacing oldBase = this.fakeBaseMode(rotation);
        TileEntityMobSpawner ret = this.setSpawner(world, x, y, z, sbb, monsterID);
        this.func_186164_a(oldBase);
        return ret;
    }

    protected void placeTreasureAtCurrentPosition(World world, Random rand, int x, int y, int z, TFTreasure treasureType, StructureBoundingBox sbb) {
        this.placeTreasureAtCurrentPosition(world, rand, x, y, z, treasureType, false, sbb);
    }

    protected void placeTreasureAtCurrentPosition(World world, Random rand, int x, int y, int z, TFTreasure treasureType, boolean trapped, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.func_74865_a(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.func_74862_a(y), dz = this.func_74873_b(x, z));
        if (sbb.func_175898_b((Vec3i)pos) && world.func_180495_p(pos).func_177230_c() != (trapped ? Blocks.field_150447_bR : Blocks.field_150486_ae)) {
            treasureType.generateChest(world, pos, trapped);
        }
    }

    protected void placeTreasureRotated(World world, int x, int y, int z, Rotation rotation, TFTreasure treasureType, StructureBoundingBox sbb) {
        this.placeTreasureRotated(world, x, y, z, rotation, treasureType, false, sbb);
    }

    protected void placeTreasureRotated(World world, int x, int y, int z, Rotation rotation, TFTreasure treasureType, boolean trapped, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.getXWithOffsetRotated(x, z, rotation);
        BlockPos pos = new BlockPos(dx, dy = this.func_74862_a(y), dz = this.getZWithOffsetRotated(x, z, rotation));
        if (sbb.func_175898_b((Vec3i)pos) && world.func_180495_p(pos).func_177230_c() != (trapped ? Blocks.field_150447_bR : Blocks.field_150486_ae)) {
            treasureType.generateChest(world, pos, trapped);
        }
    }

    protected void placeTripwire(World world, int x, int y, int z, int size, EnumFacing facing, StructureBoundingBox sbb) {
        int dx = facing.func_82601_c();
        int dz = facing.func_82599_e();
        world.captureBlockSnapshots = true;
        IBlockState tripwireHook = Blocks.field_150479_bC.func_176223_P();
        this.func_175811_a(world, tripwireHook.func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)facing.func_176734_d()), x, y, z, sbb);
        this.func_175811_a(world, tripwireHook.func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)facing), x + dx * size, y, z + dz * size, sbb);
        IBlockState tripwire = Blocks.field_150473_bD.func_176223_P();
        for (int i = 1; i < size; ++i) {
            this.func_175811_a(world, tripwire, x + dx * i, y, z + dz * i, sbb);
        }
        world.captureBlockSnapshots = false;
        List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
        world.capturedBlockSnapshots.clear();
        for (BlockSnapshot snap : blockSnapshots) {
            int updateFlag = snap.getFlag();
            IBlockState oldBlock = snap.getReplacedBlock();
            IBlockState newBlock = world.func_180495_p(snap.getPos());
            newBlock.func_177230_c().func_176213_c(world, snap.getPos(), newBlock);
            world.markAndNotifyBlock(snap.getPos(), null, oldBlock, newBlock, updateFlag);
        }
    }

    protected void placeSignAtCurrentPosition(World world, int x, int y, int z, String string0, String string1, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.func_74865_a(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.func_74862_a(y), dz = this.func_74873_b(x, z));
        if (sbb.func_175898_b((Vec3i)pos) && world.func_180495_p(pos).func_177230_c() != Blocks.field_150472_an) {
            world.func_180501_a(pos, Blocks.field_150472_an.func_176223_P().func_177226_a((IProperty)BlockStandingSign.field_176413_a, (Comparable)Integer.valueOf(this.func_186165_e().func_176736_b() * 4)), 2);
            TileEntitySign teSign = (TileEntitySign)world.func_175625_s(pos);
            if (teSign != null) {
                teSign.field_145915_a[1] = new TextComponentString(string0);
                teSign.field_145915_a[2] = new TextComponentString(string1);
            }
        }
    }

    protected void placeSignAtCurrentPosition(World world, int x, int y, int z, StructureBoundingBox sbb, String ... text) {
        int dz;
        int dy;
        int dx = this.func_74865_a(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.func_74862_a(y), dz = this.func_74873_b(x, z));
        if (sbb.func_175898_b((Vec3i)pos) && world.func_180495_p(pos).func_177230_c() != Blocks.field_150472_an) {
            world.func_180501_a(pos, Blocks.field_150472_an.func_176223_P().func_177226_a((IProperty)BlockStandingSign.field_176413_a, (Comparable)Integer.valueOf(this.func_186165_e().func_176736_b() * 4)), 2);
            TileEntitySign teSign = (TileEntitySign)world.func_175625_s(pos);
            if (teSign != null) {
                int min = Math.min(text.length, teSign.field_145915_a.length);
                for (int i = 0; i < min; ++i) {
                    teSign.field_145915_a[i] = new TextComponentString(text[i]);
                }
            }
        }
    }

    protected int[] offsetTowerCoords(int x, int y, int z, int towerSize, EnumFacing direction) {
        int dx = this.func_74865_a(x, z);
        int dy = this.func_74862_a(y);
        int dz = this.func_74873_b(x, z);
        if (direction == EnumFacing.SOUTH) {
            return new int[]{dx + 1, dy - 1, dz - towerSize / 2};
        }
        if (direction == EnumFacing.WEST) {
            return new int[]{dx + towerSize / 2, dy - 1, dz + 1};
        }
        if (direction == EnumFacing.NORTH) {
            return new int[]{dx - 1, dy - 1, dz + towerSize / 2};
        }
        if (direction == EnumFacing.EAST) {
            return new int[]{dx - towerSize / 2, dy - 1, dz - 1};
        }
        return new int[]{x, y, z};
    }

    protected BlockPos offsetTowerCCoords(int x, int y, int z, int towerSize, EnumFacing direction) {
        int dx = this.func_74865_a(x, z);
        int dy = this.func_74862_a(y);
        int dz = this.func_74873_b(x, z);
        switch (direction) {
            case SOUTH: {
                return new BlockPos(dx + 1, dy - 1, dz - towerSize / 2);
            }
            case WEST: {
                return new BlockPos(dx + towerSize / 2, dy - 1, dz + 1);
            }
            case NORTH: {
                return new BlockPos(dx - 1, dy - 1, dz + towerSize / 2);
            }
            case EAST: {
                return new BlockPos(dx - towerSize / 2, dy - 1, dz - 1);
            }
        }
        return new BlockPos(x, y, z);
    }

    protected int func_74865_a(int x, int z) {
        EnumFacing enumfacing = this.func_186165_e();
        if (enumfacing == null) {
            return x;
        }
        switch (enumfacing) {
            case SOUTH: {
                return this.field_74887_e.field_78897_a + x;
            }
            case WEST: {
                return this.field_74887_e.field_78893_d - z;
            }
            case NORTH: {
                return this.field_74887_e.field_78893_d - x;
            }
            case EAST: {
                return this.field_74887_e.field_78897_a + z;
            }
        }
        return x;
    }

    protected int func_74873_b(int x, int z) {
        EnumFacing enumfacing = this.func_186165_e();
        if (enumfacing == null) {
            return z;
        }
        switch (enumfacing) {
            case SOUTH: {
                return this.field_74887_e.field_78896_c + z;
            }
            case WEST: {
                return this.field_74887_e.field_78896_c + x;
            }
            case NORTH: {
                return this.field_74887_e.field_78892_f - z;
            }
            case EAST: {
                return this.field_74887_e.field_78892_f - x;
            }
        }
        return z;
    }

    private EnumFacing fakeBaseMode(Rotation rotationsCW) {
        EnumFacing oldBaseMode = this.func_186165_e();
        if (oldBaseMode != null) {
            EnumFacing pretendBaseMode = oldBaseMode;
            pretendBaseMode = rotationsCW.func_185831_a(pretendBaseMode);
            this.func_186164_a(pretendBaseMode);
        }
        return oldBaseMode;
    }

    protected int getXWithOffsetRotated(int x, int z, Rotation rotationsCW) {
        EnumFacing oldMode = this.fakeBaseMode(rotationsCW);
        int ret = this.func_74865_a(x, z);
        this.func_186164_a(oldMode);
        return ret;
    }

    protected int getZWithOffsetRotated(int x, int z, Rotation rotationsCW) {
        EnumFacing oldMode = this.fakeBaseMode(rotationsCW);
        int ret = this.func_74873_b(x, z);
        this.func_186164_a(oldMode);
        return ret;
    }

    protected void setBlockStateRotated(World world, IBlockState state, int x, int y, int z, Rotation rotationsCW, StructureBoundingBox sbb) {
        EnumFacing oldMode = this.fakeBaseMode(rotationsCW);
        this.func_175811_a(world, state, x, y, z, sbb);
        this.func_186164_a(oldMode);
    }

    public IBlockState func_175807_a(World world, int x, int y, int z, StructureBoundingBox sbb) {
        return super.func_175807_a(world, x, y, z, sbb);
    }

    protected void func_175811_a(World worldIn, IBlockState blockstateIn, int x, int y, int z, StructureBoundingBox sbb) {
        super.func_175811_a(worldIn, blockstateIn, x, y, z, sbb);
    }

    public IBlockState getBlockStateFromPosRotated(World world, int x, int y, int z, StructureBoundingBox sbb, Rotation rotationsCW) {
        EnumFacing oldMode = this.fakeBaseMode(rotationsCW);
        IBlockState ret = this.func_175807_a(world, x, y, z, sbb);
        this.func_186164_a(oldMode);
        return ret;
    }

    protected void fillBlocksRotated(World world, StructureBoundingBox sbb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockState state, Rotation rotation) {
        EnumFacing oldBase = this.fakeBaseMode(rotation);
        this.func_175804_a(world, sbb, minX, minY, minZ, maxX, maxY, maxZ, state, state, false);
        this.func_186164_a(oldBase);
    }

    protected void randomlyFillBlocksRotated(World worldIn, StructureBoundingBox boundingboxIn, Random rand, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockState blockstate1, IBlockState blockstate2, Rotation rotation) {
        EnumFacing oldBase = this.fakeBaseMode(rotation);
        int minimumLightLevel = 15;
        this.func_189914_a(worldIn, boundingboxIn, rand, chance, minX, minY, minZ, maxX, maxY, maxZ, blockstate1, blockstate2, false, 15);
        this.func_186164_a(oldBase);
    }

    public void replaceAirAndLiquidDownwardsRotated(World world, IBlockState state, int x, int y, int z, Rotation rotation, StructureBoundingBox sbb) {
        EnumFacing oldBaseMode = this.fakeBaseMode(rotation);
        this.func_175808_b(world, state, x, y, z, sbb);
        this.func_186164_a(oldBaseMode);
    }

    protected void fillAirRotated(World world, StructureBoundingBox sbb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Rotation rotation) {
        EnumFacing oldBaseMode = this.fakeBaseMode(rotation);
        this.func_74878_a(world, sbb, minX, minY, minZ, maxX, maxY, maxZ);
        this.func_186164_a(oldBaseMode);
    }

    protected void fillWithAir(World world, StructureBoundingBox boundingBox, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, Predicate<IBlockState> predicate) {
        this.fillWithBlocks(world, boundingBox, xMin, yMin, zMin, xMax, yMax, zMax, Blocks.field_150350_a.func_176223_P(), predicate);
    }

    protected void fillWithBlocks(World world, StructureBoundingBox boundingBox, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, IBlockState state, Predicate<IBlockState> predicate) {
        this.fillWithBlocks(world, boundingBox, xMin, yMin, zMin, xMax, yMax, zMax, state, state, predicate);
    }

    protected void fillWithBlocks(World world, StructureBoundingBox boundingBox, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, IBlockState borderState, IBlockState interiorState, Predicate<IBlockState> predicate) {
        for (int y = yMin; y <= yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (!predicate.test(this.func_175807_a(world, x, y, z, boundingBox))) continue;
                    boolean isBorder = yMin != yMax && (y == yMin || y == yMax) || xMin != xMax && (x == xMin || x == xMax) || zMin != zMax && (z == zMin || z == zMax);
                    this.func_175811_a(world, isBorder ? borderState : interiorState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected static StructureComponent.BlockSelector getStrongholdStones() {
        return strongholdStones;
    }

    protected EnumFacing getStructureRelativeRotation(Rotation rotationsCW) {
        return rotationsCW.func_185831_a(this.func_186165_e());
    }

    public void nullifySkyLightForBoundingBox(World world) {
        this.nullifySkyLight(world, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1, this.field_74887_e.field_78896_c - 1, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e + 1, this.field_74887_e.field_78892_f + 1);
    }

    protected void nullifySkyLightAtCurrentPosition(World world, int sx, int sy, int sz, int dx, int dy, int dz) {
        this.nullifySkyLight(world, this.func_74865_a(sx, sz), this.func_74862_a(sy), this.func_74873_b(sx, sz), this.func_74865_a(dx, dz), this.func_74862_a(dy), this.func_74873_b(dx, dz));
    }

    protected void nullifySkyLight(World world, int sx, int sy, int sz, int dx, int dy, int dz) {
        for (int x = sx; x <= dx; ++x) {
            for (int z = sz; z <= dz; ++z) {
                for (int y = sy; y <= dy; ++y) {
                    world.func_175653_a(EnumSkyBlock.SKY, new BlockPos(x, y, z), 0);
                }
            }
        }
    }

    protected int getAverageGroundLevel(World world, StructureBoundingBox sbb) {
        int totalHeight = 0;
        int heightCount = 0;
        for (int bz = this.field_74887_e.field_78896_c; bz <= this.field_74887_e.field_78892_f; ++bz) {
            for (int by = this.field_74887_e.field_78897_a; by <= this.field_74887_e.field_78893_d; ++by) {
                BlockPos pos = new BlockPos(by, 64, bz);
                if (!sbb.func_175898_b((Vec3i)pos)) continue;
                totalHeight += Math.max(world.func_175672_r(pos).func_177956_o(), world.field_73011_w.func_76557_i());
                ++heightCount;
            }
        }
        if (heightCount == 0) {
            return -1;
        }
        return totalHeight / heightCount;
    }

    protected int findGroundLevel(World world, StructureBoundingBox sbb, int start, Predicate<IBlockState> predicate) {
        Vec3i center = StructureBoundingBoxUtils.getCenter(sbb);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(center.func_177958_n(), 0, center.func_177952_p());
        for (int y = start; y > 0; --y) {
            pos.func_185336_p(y);
            if (!predicate.test(world.func_180495_p((BlockPos)pos))) continue;
            return y;
        }
        return 0;
    }

    protected boolean isBoundingBoxOutsideBiomes(World world, StructureBoundingBox sbb, Predicate<Biome> predicate) {
        int minX = this.field_74887_e.field_78897_a - 1;
        int minZ = this.field_74887_e.field_78896_c - 1;
        int maxX = this.field_74887_e.field_78893_d + 1;
        int maxZ = this.field_74887_e.field_78892_f + 1;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (predicate.test(world.func_180494_b((BlockPos)pos.func_181079_c(x, 0, z)))) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static StructureComponent findIntersectingExcluding(List<StructureComponent> list, StructureBoundingBox toCheck, StructureComponent exclude) {
        StructureComponent structurecomponent;
        Iterator<StructureComponent> iterator = list.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while ((structurecomponent = iterator.next()) == exclude || structurecomponent.func_74874_b() == null || !structurecomponent.func_74874_b().func_78884_a(toCheck));
        return structurecomponent;
    }

    public BlockPos getBlockPosWithOffset(int x, int y, int z) {
        return new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
    }

    protected static IBlockState getStairState(IBlockState stairState, EnumFacing direction, Rotation rotation, boolean isTopHalf) {
        return stairState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)direction).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)(isTopHalf ? BlockStairs.EnumHalf.TOP : BlockStairs.EnumHalf.BOTTOM));
    }

    protected static IBlockState getSlabState(IBlockState inputBlockState, BlockPlanks.EnumType type, BlockSlab.EnumBlockHalf half) {
        return inputBlockState.func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)type).func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)half);
    }
}

