/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils;

import com.windanesz.wizardryutils.ArtefactSettings;
import com.windanesz.wizardryutils.CommonProxy;
import com.windanesz.wizardryutils.capability.SummonedCreatureData;
import com.windanesz.wizardryutils.capability.SummonedItemCapability;
import com.windanesz.wizardryutils.integration.baubles.BaublesIntegration;
import com.windanesz.wizardryutils.integration.crafttweaker.CrafttweakerIntegration;
import com.windanesz.wizardryutils.registry.ItemModelRegistry;
import com.windanesz.wizardryutils.registry.LootRegistry;
import com.windanesz.wizardryutils.server.Attributes;
import java.util.Random;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="wizardryutils", name="WizardryUtils", version="1.3.0", acceptedMinecraftVersions="1.12.2", dependencies="required-after:ebwizardry@[4.3.15,4.4)")
public class WizardryUtils {
    public static final String MODID = "wizardryutils";
    public static final String NAME = "WizardryUtils";
    public static final Random rand = new Random();
    public static Logger logger;
    @Mod.Instance(value="wizardryutils")
    public static WizardryUtils instance;
    @SidedProxy(clientSide="com.windanesz.wizardryutils.client.ClientProxy", serverSide="com.windanesz.wizardryutils.CommonProxy")
    public static CommonProxy proxy;
    public static final ArtefactSettings artefactSettings;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Attributes.init();
        logger = event.getModLog();
        proxy.registerRenderers();
        ItemModelRegistry.registerModForAutoItemModelRegistry(MODID);
        LootRegistry.preInit();
        BaublesIntegration.init();
        CrafttweakerIntegration.init();
        SummonedCreatureData.register();
        SummonedItemCapability.register();
        artefactSettings.initConfig(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        artefactSettings.initConfigExtras();
        MinecraftForge.EVENT_BUS.register((Object)instance);
        proxy.registerParticles();
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStartup(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onArtefactConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            artefactSettings.saveConfigChanges();
        }
    }

    static {
        artefactSettings = new ArtefactSettings();
    }
}

