/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.capability;

import com.windanesz.wizardryutils.capability.SummonedThing;
import java.util.HashSet;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class SummonedItemCapability
extends SummonedThing
implements INBTSerializable<NBTTagCompound> {
    public static HashSet<Item> ITEMS_TO_APPLY_TO = new HashSet();
    @CapabilityInject(value=SummonedItemCapability.class)
    private static final Capability<SummonedItemCapability> SUMMONED_ITEM_CAPABILITY = null;
    private final ItemStack stack;

    public SummonedItemCapability() {
        this(null);
    }

    public SummonedItemCapability(ItemStack stack) {
        this.stack = stack;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(SummonedItemCapability.class, (Capability.IStorage)new Capability.IStorage<SummonedItemCapability>(){

            public NBTBase writeNBT(Capability<SummonedItemCapability> capability, SummonedItemCapability instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<SummonedItemCapability> capability, SummonedItemCapability instance, EnumFacing side, NBTBase nbt) {
            }
        }, SummonedItemCapability::new);
    }

    public static SummonedItemCapability get(ItemStack stack) {
        return (SummonedItemCapability)stack.getCapability(SUMMONED_ITEM_CAPABILITY, null);
    }

    public static boolean isSummonedItem(ItemStack stack) {
        return stack != null && stack != ItemStack.field_190927_a && SummonedItemCapability.get(stack) != null && SummonedItemCapability.get((ItemStack)stack).summoned;
    }

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<ItemStack> event) {
        if (event.getObject() != null && ITEMS_TO_APPLY_TO.contains(((ItemStack)event.getObject()).func_77973_b())) {
            event.addCapability(new ResourceLocation("wizardryutils", "SummonedItemData"), (ICapabilityProvider)new Provider((ItemStack)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onItemTossEvent(ItemTossEvent event) {
        if (SummonedItemCapability.isSummonedItem(event.getEntityItem().func_92059_d())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDropsEvent(LivingDropsEvent event) {
        for (EntityItem item : event.getDrops()) {
            if (item == null || item.func_92059_d() == null || !SummonedItemCapability.isSummonedItem(item.func_92059_d())) continue;
            item.func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayer player = event.player;
            for (ItemStack stack : player.field_71071_by.field_184439_c) {
                if (!SummonedItemCapability.isSummonedItem(player.func_184592_cb())) continue;
                if (player.func_184592_cb() != stack) {
                    stack.func_190918_g(1);
                    return;
                }
                SummonedItemCapability.get(stack).updateDelegate(stack);
            }
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (!SummonedItemCapability.isSummonedItem(stack)) continue;
                if (player.func_184614_ca() != stack) {
                    stack.func_190918_g(1);
                    return;
                }
                SummonedItemCapability.get(stack).updateDelegate(stack);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractEvent(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
            EntityPlayer player = event.getEntityPlayer();
            if (SummonedItemCapability.isSummonedItem(player.func_184592_cb())) {
                player.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
            }
            if (SummonedItemCapability.isSummonedItem(player.func_184614_ca())) {
                player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            }
        }
    }

    void updateDelegate(ItemStack stack) {
        if (!this.summoned) {
            return;
        }
        if (this.getLifetime() <= 0) {
            this.stack.func_190918_g(1);
        }
        this.setLifetime(this.getLifetime() - 1);
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final SummonedItemCapability data;

        public Provider(ItemStack stack) {
            this.data = new SummonedItemCapability(stack);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == SUMMONED_ITEM_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == SUMMONED_ITEM_CAPABILITY) {
                return (T)SUMMONED_ITEM_CAPABILITY.cast((Object)this.data);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return this.data.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.data.deserializeNBT(nbt);
        }
    }
}

