/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.entity;

import com.windanesz.wizardryutils.WizardryUtils;
import electroblob.wizardry.entity.construct.EntityScaledConstruct;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDynamicConstruct
extends EntityScaledConstruct {
    protected float sizeMultiplier = 1.0f;
    private Supplier<Potion>[] potionSuppliers;
    private float r;
    private float g;
    private float b;
    private double effectRadius = 3.0;
    private int tickInterval = 20;
    private int creatureTargeting = 0;
    private int lifetime = 600;
    private UUID casterUUID;
    private EntityLivingBase casterCache;
    private SpellModifiers modifiers = new SpellModifiers();

    public EntityDynamicConstruct(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70145_X = true;
    }

    public EntityDynamicConstruct(World world, double x, double y, double z, EntityLivingBase caster, int lifetime, float r, float g, float b, Supplier<Potion>[] potionSuppliers, double effectRadius) {
        this(world);
        this.func_70107_b(x, y, z);
        this.r = r;
        this.g = g;
        this.b = b;
        this.potionSuppliers = potionSuppliers;
        this.effectRadius = effectRadius;
        this.lifetime = lifetime;
        if (caster != null) {
            this.casterUUID = caster.func_110124_au();
            this.casterCache = caster;
        }
    }

    public float getSizeMultiplier() {
        return this.sizeMultiplier;
    }

    public void setSizeMultiplier(float sizeMultiplier) {
        this.sizeMultiplier = sizeMultiplier;
        this.func_70105_a(this.shouldScaleWidth() ? this.field_70130_N * sizeMultiplier : this.field_70130_N, this.shouldScaleHeight() ? this.field_70131_O * sizeMultiplier : this.field_70131_O);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > this.lifetime && this.lifetime != -1) {
            this.despawn();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % this.tickInterval == 0 && this.potionSuppliers != null) {
            this.applyEffects();
        }
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
        }
    }

    private void applyEffects() {
        double radius = this.effectRadius * (double)this.modifiers.get(WizardryItems.blast_upgrade);
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_70165_t - radius, this.field_70163_u - radius, this.field_70161_v - radius, this.field_70165_t + radius, this.field_70163_u + radius, this.field_70161_v + radius);
        List targets = this.field_70170_p.func_72872_a(EntityLivingBase.class, aabb);
        for (EntityLivingBase target : targets) {
            if (target == null) continue;
            if (this.getCaster() != null) {
                boolean isAlly;
                boolean isCaster = target == this.getCaster();
                boolean bl = isAlly = !AllyDesignationSystem.isValidTarget((Entity)this.getCaster(), (Entity)target);
                if (this.creatureTargeting == 0 ? isAlly || isCaster : (this.creatureTargeting == 1 ? !isAlly || isCaster : this.creatureTargeting == 2 && !isAlly && !isCaster)) continue;
            }
            for (Supplier<Potion> potionSupplier : this.potionSuppliers) {
                Potion potion;
                if (potionSupplier == null || (potion = potionSupplier.get()) == null) continue;
                int duration = (int)(600.0f * this.modifiers.get(WizardryItems.duration_upgrade));
                int amplifier = (int)(this.modifiers.get("potency") - 1.0f);
                target.func_70690_d(new PotionEffect(potion, duration, amplifier, false, true));
            }
        }
    }

    private void spawnParticles() {
        double radius = this.effectRadius * (double)this.modifiers.get(WizardryItems.blast_upgrade);
        for (int i = 0; i < 3; ++i) {
            double dx = (this.field_70146_Z.nextDouble() - 0.5) * radius * 2.0;
            double dy = (this.field_70146_Z.nextDouble() - 0.5) * radius * 2.0;
            double dz = (this.field_70146_Z.nextDouble() - 0.5) * radius * 2.0;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(this.field_70165_t + dx, this.field_70163_u + dy, this.field_70161_v + dz).vel(0.0, 0.02, 0.0).clr(this.r, this.g, this.b).spawn(this.field_70170_p);
        }
    }

    protected boolean shouldScaleWidth() {
        return true;
    }

    protected boolean shouldScaleHeight() {
        return true;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.lifetime);
        data.writeInt(this.getCaster() == null ? -1 : this.getCaster().func_145782_y());
        data.writeFloat(this.sizeMultiplier);
        data.writeFloat(this.r);
        data.writeFloat(this.g);
        data.writeFloat(this.b);
        data.writeFloat(this.modifiers.get(WizardryItems.blast_upgrade));
    }

    public void readSpawnData(ByteBuf data) {
        this.lifetime = data.readInt();
        int id = data.readInt();
        if (id == -1) {
            this.setCaster(null);
        } else {
            Entity entity = this.field_70170_p.func_73045_a(id);
            if (entity instanceof EntityLivingBase) {
                this.setCaster((EntityLivingBase)entity);
            } else {
                WizardryUtils.logger.warn("Construct caster with ID in spawn data not found");
            }
        }
        this.setSizeMultiplier(data.readFloat());
        this.r = data.readFloat();
        this.g = data.readFloat();
        this.b = data.readFloat();
        float blastModifier = data.readFloat();
        this.modifiers.set(WizardryItems.blast_upgrade, blastModifier, false);
    }

    public EntityDynamicConstruct setModifiers(SpellModifiers modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public EntityDynamicConstruct setEffectRadius(double radius) {
        this.effectRadius = radius;
        return this;
    }

    public EntityDynamicConstruct setTickInterval(int interval) {
        this.tickInterval = interval;
        return this;
    }

    public EntityDynamicConstruct setCreatureTargeting(int creatureTargeting) {
        this.creatureTargeting = creatureTargeting;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        if (this.lifetime == -1 && this.getCaster() == player && player.func_70093_af() && player.func_184586_b(hand).func_77973_b() instanceof ISpellCastingItem) {
            this.despawn();
            return EnumActionResult.SUCCESS;
        }
        return super.func_184199_a(player, vec, hand);
    }

    public void despawn() {
        this.func_70106_y();
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_186855_b("casterUUID")) {
            this.casterUUID = nbt.func_186857_a("casterUUID");
        }
        this.lifetime = nbt.func_74762_e("lifetime");
        this.damageMultiplier = nbt.func_74760_g("damageMultiplier");
        this.setSizeMultiplier(nbt.func_74760_g("sizeMultiplier"));
        this.creatureTargeting = nbt.func_74762_e("creatureTargeting");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.casterUUID != null) {
            nbt.func_186854_a("casterUUID", this.casterUUID);
        }
        nbt.func_74768_a("lifetime", this.lifetime);
        nbt.func_74776_a("damageMultiplier", this.damageMultiplier);
        nbt.func_74776_a("sizeMultiplier", this.sizeMultiplier);
        nbt.func_74768_a("creatureTargeting", this.creatureTargeting);
    }

    @Nullable
    public UUID func_184753_b() {
        return this.casterUUID;
    }

    @Nullable
    public Entity func_70902_q() {
        return this.getCaster();
    }

    @Nullable
    public EntityLivingBase getCaster() {
        Entity entity = EntityUtils.getEntityByUUID((World)this.field_70170_p, (UUID)this.func_184753_b());
        if (entity != null && !(entity instanceof EntityLivingBase)) {
            WizardryUtils.logger.warn("{} has a non-living owner!", (Object)this);
            entity = null;
        }
        return (EntityLivingBase)entity;
    }

    public void setCaster(@Nullable EntityLivingBase caster) {
        this.casterUUID = caster == null ? null : caster.func_110124_au();
    }

    public boolean isValidTarget(Entity target) {
        return AllyDesignationSystem.isValidTarget((Entity)this.getCaster(), (Entity)target);
    }

    public SoundCategory func_184176_by() {
        return WizardrySounds.SPELLS;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }
}

