/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.integration.baubles;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import com.windanesz.wizardryutils.Settings;
import com.windanesz.wizardryutils.item.ITickableArtefact;
import com.windanesz.wizardryutils.item.ItemNewArtefact;
import electroblob.wizardry.item.ItemArtefact;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Loader;

public final class BaublesIntegration {
    public static final String BAUBLES_MOD_ID = "baubles";
    private static final Map<ItemArtefact.Type, BaubleType> DEFAULT_ARTEFACT_TYPE_MAP = new EnumMap<ItemArtefact.Type, BaubleType>(ItemArtefact.Type.class);
    private static final Map<ItemNewArtefact.Type, BaubleType> OTHER_ARTEFACT_TYPE_MAP = new EnumMap<ItemNewArtefact.Type, BaubleType>(ItemNewArtefact.Type.class);
    private static boolean baublesLoaded;

    public static void init() {
        baublesLoaded = Loader.isModLoaded((String)BAUBLES_MOD_ID);
        if (!BaublesIntegration.enabled()) {
            return;
        }
        DEFAULT_ARTEFACT_TYPE_MAP.put(ItemArtefact.Type.RING, BaubleType.RING);
        DEFAULT_ARTEFACT_TYPE_MAP.put(ItemArtefact.Type.AMULET, BaubleType.AMULET);
        DEFAULT_ARTEFACT_TYPE_MAP.put(ItemArtefact.Type.CHARM, BaubleType.CHARM);
        OTHER_ARTEFACT_TYPE_MAP.put(ItemNewArtefact.Type.BELT, BaubleType.BELT);
        OTHER_ARTEFACT_TYPE_MAP.put(ItemNewArtefact.Type.HEAD, BaubleType.HEAD);
        OTHER_ARTEFACT_TYPE_MAP.put(ItemNewArtefact.Type.BODY, BaubleType.BODY);
    }

    public static boolean enabled() {
        return Settings.generalSettings.baubles_integration && baublesLoaded;
    }

    public static List<ItemNewArtefact> getEquippedArtefacts(EntityPlayer player, ItemNewArtefact.Type ... types) {
        ArrayList<ItemNewArtefact> artefacts = new ArrayList<ItemNewArtefact>();
        for (ItemNewArtefact.Type type : types) {
            for (int slot : OTHER_ARTEFACT_TYPE_MAP.get((Object)type).getValidSlots()) {
                ItemStack stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(slot);
                if (!(stack.func_77973_b() instanceof ItemNewArtefact)) continue;
                artefacts.add((ItemNewArtefact)stack.func_77973_b());
            }
        }
        return artefacts;
    }

    public static Map<Integer, ItemStack> getAllEquippedArtefacts(EntityPlayer player) {
        HashMap<Integer, ItemStack> artefacts = new HashMap<Integer, ItemStack>();
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int slot = 0; slot < baubles.getSlots(); ++slot) {
            ItemStack stack = baubles.getStackInSlot(slot);
            if (!(stack.func_77973_b() instanceof ItemArtefact) && !(stack.func_77973_b() instanceof ItemArtefact)) continue;
            artefacts.put(slot, stack);
        }
        return artefacts;
    }

    public static List<ItemStack> getEquippedArtefactStacks(EntityPlayer player, Object ... artefactType) {
        ArrayList<ItemStack> artefacts = new ArrayList<ItemStack>();
        for (Object type : artefactType) {
            ItemStack stack;
            if (type instanceof ItemArtefact.Type) {
                for (int slot : DEFAULT_ARTEFACT_TYPE_MAP.get((ItemArtefact.Type)type).getValidSlots()) {
                    stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(slot);
                    if (!(stack.func_77973_b() instanceof ItemArtefact)) continue;
                    artefacts.add(stack);
                }
                continue;
            }
            if (!(type instanceof ItemNewArtefact.Type)) continue;
            for (int slot : OTHER_ARTEFACT_TYPE_MAP.get((Object)((ItemNewArtefact.Type)((Object)type))).getValidSlots()) {
                stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(slot);
                if (!(stack.func_77973_b() instanceof ItemNewArtefact)) continue;
                artefacts.add(stack);
            }
        }
        return artefacts;
    }

    public static void setArtefactToSlot(EntityPlayer player, ItemStack stack, ItemArtefact.Type type) {
        BaublesIntegration.setArtefactToSlot(player, stack, type, 0);
    }

    public static void setArtefactToSlot(EntityPlayer player, ItemStack stack, ItemArtefact.Type type, int slotId) {
        BaublesApi.getBaublesHandler((EntityPlayer)player).setStackInSlot(DEFAULT_ARTEFACT_TYPE_MAP.get(type).getValidSlots()[slotId], stack);
    }

    public static void tickWornArtefacts(EntityPlayer player) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int i = 0; i < baubles.getSlots(); ++i) {
            ItemStack stack = baubles.getStackInSlot(i);
            Item item = stack.func_77973_b();
            if (!(item instanceof ITickableArtefact)) continue;
            boolean enabled = true;
            if (item instanceof ItemArtefact) {
                enabled = ((ItemArtefact)item).isEnabled();
            } else if (item instanceof ItemNewArtefact) {
                enabled = ((ItemNewArtefact)item).isEnabled();
            }
            if (!enabled) continue;
            ((ITickableArtefact)stack.func_77973_b()).onWornTick(stack, (EntityLivingBase)player);
        }
    }

    public static final class ArtefactBaubleProvider
    implements ICapabilityProvider {
        private BaubleType type;

        public ArtefactBaubleProvider(ItemNewArtefact.Type type) {
            this.type = (BaubleType)OTHER_ARTEFACT_TYPE_MAP.get((Object)type);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE ? itemStack -> this.type : null);
        }
    }
}

