/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.integration.crafttweaker.spell;

import com.windanesz.wizardryutils.spell.SpellDynamicAreaEffect;
import crafttweaker.annotations.ZenRegister;
import electroblob.wizardry.spell.Spell;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.wizardryutils.AreaEffectSpells")
@ZenRegister
public class ZenAreaEffectSpell {
    public static final List<AreaEffectSpellEntry> entries = new ArrayList<AreaEffectSpellEntry>();

    @ZenMethod
    public static void create(String name, float r, float g, float b, String[] potions) {
        entries.add(new AreaEffectSpellEntry(name, potions, r, g, b));
    }

    public static Spell instantiate(AreaEffectSpellEntry entry) {
        if (entry == null) {
            throw new RuntimeException("AreaEffectSpellEntry cannot be null!");
        }
        Supplier[] potionSuppliers = new Supplier[entry.potions.length];
        for (int i = 0; i < entry.potions.length; ++i) {
            String potionName = entry.potions[i];
            Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potionName));
            if (potion == null) {
                throw new RuntimeException("Could not find potion effect " + potionName + "!");
            }
            potionSuppliers[i] = () -> potion;
        }
        SpellDynamicAreaEffect spell = new SpellDynamicAreaEffect("contenttweaker", entry.name, entry.r, entry.g, entry.b, potionSuppliers);
        return spell;
    }

    public static final class AreaEffectSpellEntry {
        public final String name;
        public final String[] potions;
        public final float r;
        public final float g;
        public final float b;

        public AreaEffectSpellEntry(String name, String[] potions, float r, float g, float b) {
            this.name = name;
            this.potions = potions;
            this.r = r;
            this.g = g;
            this.b = b;
        }
    }
}

