/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.integration.crafttweaker.spell;

import com.windanesz.wizardryutils.spell.SpellDynamicConjuration;
import crafttweaker.annotations.ZenRegister;
import electroblob.wizardry.spell.Spell;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.wizardryutils.ConjurationSpells")
@ZenRegister
public class ZenItemConjuration {
    public static final List<ConjurationSpellEntry> entries = new ArrayList<ConjurationSpellEntry>();

    @ZenMethod
    public static void create(String name, String itemRegistryName) {
        entries.add(new ConjurationSpellEntry(name, itemRegistryName));
    }

    public static Spell instantiate(ConjurationSpellEntry entry) {
        if (entry == null) {
            throw new RuntimeException("ConjurationSpellEntry cannot be null!");
        }
        String name = entry.name;
        String itemRegistryName = entry.itemRegistryName;
        SpellDynamicConjuration spell = new SpellDynamicConjuration("contenttweaker", name, () -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemRegistryName));
            if (item == null) {
                throw new RuntimeException("Could not find item " + itemRegistryName + " in registry!");
            }
            return item;
        });
        return spell;
    }

    public static final class ConjurationSpellEntry {
        public final String name;
        public final String itemRegistryName;

        public ConjurationSpellEntry(String name, String itemRegistryName) {
            this.name = name;
            this.itemRegistryName = itemRegistryName;
        }
    }
}

